/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.common;

import java.util.Properties;
import java.util.Timer;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.Velocity;
import org.glite.security.voms.admin.common.VOMSConfiguration;
import org.glite.security.voms.admin.common.VOMSConfigurationException;
import org.glite.security.voms.admin.common.VOMSFatalException;
import org.glite.security.voms.admin.common.tasks.ExpiredRequestsPurgerTask;
import org.glite.security.voms.admin.common.tasks.UpdateCATask;

public final class VOMSService {
    static final Log log = LogFactory.getLog(VOMSService.class);
    static final Timer vomsTimer = new Timer(true);

    public static void start(ServletContext ctxt) {
        VOMSConfiguration conf;
        try {
            conf = VOMSConfiguration.instance(ctxt);
        }
        catch (VOMSConfigurationException e) {
            log.fatal((Object)"VOMS-Admin configuration failed!", (Throwable)e);
            throw new VOMSFatalException(e);
        }
        log.info((Object)("VOMS-Admin starting for vo:" + conf.getVOName()));
        log.info((Object)"Configuration setup ok.");
        UpdateCATask.instance(VOMSService.getTimer());
        try {
            Properties p = new Properties();
            p.put("resource.loader", "file");
            p.put("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.FileResourceLoader");
            p.put("file.resource.loader.path", conf.getTemplatePath());
            p.put("runtime.log.logsystem.class", "org.glite.security.voms.admin.velocity.VelocityLogger");
            Velocity.init((Properties)p);
            log.info((Object)"Velocity setup ok!");
        }
        catch (Exception e) {
            log.error((Object)"Error initializing velocity template engine!");
            throw new VOMSFatalException(e);
        }
        ExpiredRequestsPurgerTask.instance(VOMSService.getTimer());
        log.info((Object)"VOMS-Admin started succesfully.");
    }

    public static void stop() {
        VOMSService.getTimer().cancel();
        log.info((Object)"VOMS admin stopped .");
    }

    public static Timer getTimer() {
        return vomsTimer;
    }
}

