/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.common.tasks;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.admin.common.DNUtil;
import org.glite.security.voms.admin.common.VOMSConfiguration;
import org.glite.security.voms.admin.dao.VOMSAdminDAO;
import org.glite.security.voms.admin.dao.VOMSCADAO;
import org.glite.security.voms.admin.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.dao.VOMSVersionDAO;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.glite.security.voms.admin.model.ACL;
import org.glite.security.voms.admin.model.VOMSAdmin;
import org.glite.security.voms.admin.model.VOMSCA;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSRole;
import org.glite.security.voms.admin.model.VOMSSeqNumber;
import org.glite.security.voms.admin.operations.VOMSPermission;

public class DatabaseSetupTask
extends TimerTask {
    private static final Log log = LogFactory.getLog(DatabaseSetupTask.class);
    private Timer timer;
    private static DatabaseSetupTask instance = null;

    public static DatabaseSetupTask instance() {
        return DatabaseSetupTask.instance(null);
    }

    public static DatabaseSetupTask instance(Timer t) {
        if (instance == null) {
            instance = new DatabaseSetupTask(t);
        }
        return instance;
    }

    private DatabaseSetupTask(Timer timer) {
        this.timer = timer;
    }

    public void run() {
        List admins = VOMSAdminDAO.instance().getAll();
        List cas = VOMSCADAO.instance().getAll();
        if (admins.isEmpty() || cas.isEmpty()) {
            VOMSCADAO caDAO = VOMSCADAO.instance();
            caDAO.createCA("/O=VOMS/O=System/CN=Dummy Certificate Authority", "A dummy CA for local org.glite.security.voms.admin.database mainteneance");
            caDAO.createCA("/O=VOMS/O=System/CN=VOMS Group", "A virtual CA for VOMS groups.");
            caDAO.createCA("/O=VOMS/O=System/CN=VOMS Role", "A virtual CA for VOMS roles.");
            caDAO.createCA("/O=VOMS/O=System/CN=Authorization Manager Attributes", "A virtual CA for authz manager attributes");
            VOMSGroup voGroup = VOMSGroupDAO.instance().createVOGroup();
            VOMSVersionDAO.instance().setupVersion();
            VOMSAdminDAO adminDAO = VOMSAdminDAO.instance();
            VOMSAdmin internalAdmin = adminDAO.create("/O=VOMS/O=System/CN=Internal VOMS Process", "/O=VOMS/O=System/CN=Dummy Certificate Authority");
            VOMSAdmin localAdmin = adminDAO.create("/O=VOMS/O=System/CN=Local Database Administrator", "/O=VOMS/O=System/CN=Dummy Certificate Authority");
            adminDAO.create("/O=VOMS/O=System/CN=Absolutely Anyone", "/O=VOMS/O=System/CN=Dummy Certificate Authority");
            adminDAO.create("/O=VOMS/O=System/CN=Any Authenticated User", "/O=VOMS/O=System/CN=Dummy Certificate Authority");
            VOMSPermission allPermissions = VOMSPermission.getAllPermissions();
            ACL voGroupACL = new ACL(voGroup, false);
            voGroup.getAcls().add(voGroupACL);
            voGroupACL.setPermissions(localAdmin, allPermissions);
            voGroupACL.setPermissions(internalAdmin, allPermissions);
            VOMSRole voAdminRole = VOMSRoleDAO.instance().create("VO-Admin");
            VOMSAdmin voAdmin = VOMSAdminDAO.instance().create(voGroup.getName() + "/Role=VO-Admin");
            voGroupACL.setPermissions(voAdmin, allPermissions);
            VOMSSeqNumber seqNum = new VOMSSeqNumber();
            seqNum.setSeq("0");
            HibernateFactory.getSession().save((Object)seqNum);
            String trustedAdminDn = VOMSConfiguration.instance().getString("voms.trusted.admin.subject");
            if (trustedAdminDn == null) {
                voAdminRole.importACL(voGroup);
                HibernateFactory.commitTransaction();
                return;
            }
            String trustedAdminCa = VOMSConfiguration.instance().getString("voms.trusted.admin.ca");
            if (trustedAdminCa == null) {
                log.error((Object)"Missing \"voms.trusted.admin.ca\" configuration parameter. Skipping creation of the trusted admin...");
                return;
            }
            VOMSCA ca = VOMSCADAO.instance().getByName(trustedAdminCa);
            if (ca == null) {
                log.error((Object)("Trusted admin ca \"" + trustedAdminCa + "\" not found in org.glite.security.voms.admin.database. Skipping creation of the trusted admin..."));
                return;
            }
            VOMSAdmin trustedAdmin = VOMSAdminDAO.instance().getByName(trustedAdminDn, ca.getDn());
            if (trustedAdmin == null) {
                String emailAddress = DNUtil.getEmailAddressFromDN(trustedAdminDn);
                trustedAdmin = VOMSAdminDAO.instance().create(trustedAdminDn, ca.getDn(), emailAddress);
            }
            voGroupACL.setPermissions(trustedAdmin, allPermissions);
            log.info((Object)"Trusted admin created.");
            voAdminRole.importACL(voGroup);
            HibernateFactory.commitTransaction();
        }
    }
}

