/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.common.tasks;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.admin.common.VOMSConfiguration;
import org.glite.security.voms.admin.dao.RequestDAO;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.glite.security.voms.admin.model.VOMembershipRequest;
import org.glite.security.voms.admin.notification.ExpiredRequestNotification;

public class ExpiredRequestsPurgerTask
extends TimerTask {
    private static final Log log = LogFactory.getLog(ExpiredRequestsPurgerTask.class);
    private static final long period = 300L;
    private Timer timer;
    private long requestLifetime;
    private boolean warnUsers;

    private ExpiredRequestsPurgerTask(Timer t) {
        this.timer = t;
        VOMSConfiguration conf = VOMSConfiguration.instance();
        this.requestLifetime = conf.getLong("voms.request.vo_membership.lifetime", 300L);
        this.warnUsers = conf.getBoolean("voms.request.vo_membership.warn_when_expired", false);
        if (this.timer != null) {
            if (this.requestLifetime > 0L) {
                log.info((Object)"Scheduling expired request reaper thread with period:300 seconds.");
                this.timer.schedule((TimerTask)this, 300000L, 300000L);
            } else {
                log.info((Object)"Request purger not started according to configuration (negative lifetime for requests!).");
            }
        }
    }

    public void run() {
        log.info((Object)"Checking for expired requests...");
        this.purgeExpiredRequests();
        log.info((Object)"Done.");
    }

    public void purgeExpiredRequests() {
        List request = RequestDAO.instance().getUnconfirmed();
        for (VOMembershipRequest r : request) {
            long creationTime;
            long currentTime = System.currentTimeMillis();
            if (currentTime - (creationTime = r.getCreationDate().getTime()) <= this.requestLifetime * 1000L) continue;
            log.info((Object)("Purging expired request #" + r.getId()));
            log.debug((Object)("Request: " + r.toString()));
            log.debug((Object)("(currentTime - creationTime ):" + (currentTime - creationTime)));
            log.debug((Object)("requestLifetime:" + this.requestLifetime * 1000L));
            RequestDAO dao = RequestDAO.instance();
            dao.delete(r);
            if (this.warnUsers) {
                ExpiredRequestNotification n = new ExpiredRequestNotification(r.getEmailAddress());
                n.send();
            }
            HibernateFactory.commitTransaction();
        }
    }

    public static ExpiredRequestsPurgerTask instance(Timer t) {
        return new ExpiredRequestsPurgerTask(t);
    }
}

