/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.common.tasks;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.util.FileCertReader;
import org.glite.security.voms.admin.common.DNUtil;
import org.glite.security.voms.admin.common.VOMSConfiguration;
import org.glite.security.voms.admin.common.VOMSException;
import org.glite.security.voms.admin.dao.VOMSCADAO;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.glite.security.voms.admin.database.VOMSDatabaseException;

public final class UpdateCATask
extends TimerTask {
    static final Log log = LogFactory.getLog(UpdateCATask.class);
    private static UpdateCATask instance = null;
    protected Timer timer;

    public static UpdateCATask instance(Timer theTimer) {
        if (instance == null) {
            instance = new UpdateCATask(theTimer);
        }
        return instance;
    }

    private UpdateCATask(Timer theTimer) {
        this.timer = theTimer;
        VOMSConfiguration config = VOMSConfiguration.instance();
        if (config.getBoolean("voms.readonly", false)) {
            log.info((Object)"CA update thread not started.  This is a read-only VOMS Admin instance");
            return;
        }
        if (this.timer != null) {
            long period = config.getLong("voms.cafiles.period", -1L);
            if (period > 0L) {
                log.info((Object)("Scheduling UpdateCATask with period: " + period + " seconds."));
                this.timer.schedule((TimerTask)this, 60000L, period * 1000L);
            } else {
                log.info((Object)"CA update thread not started. voms.cafiles.period is negative or undefined.");
                return;
            }
        }
    }

    public void run() {
        log.info((Object)"CA update thread started...");
        HibernateFactory.beginTransaction();
        UpdateCATask.updateCAs();
        HibernateFactory.commitTransaction();
        log.info((Object)"CA update thread done.");
    }

    public static synchronized void updateCAs() {
        String caFiles = VOMSConfiguration.instance().getString("voms.cafiles", "/etc/grid-security/certificates/*.0");
        log.info((Object)("Updating CAs from: " + caFiles));
        if (caFiles != null) {
            try {
                FileCertReader certReader = new FileCertReader();
                Vector cas = certReader.readAnchors(caFiles);
                for (TrustAnchor anchor : cas) {
                    X509Certificate caCert = anchor.getTrustedCert();
                    String caDN = DNUtil.getBCasX500(caCert.getSubjectX500Principal());
                    log.debug((Object)("Checking CA: " + caDN));
                    VOMSCADAO caDAO = VOMSCADAO.instance();
                    caDAO.saveTrustedCA(caDN);
                }
            }
            catch (CertificateException e) {
                log.error((Object)"Certificate parsing error while updating trusted CA org.glite.security.voms.admin.database!", (Throwable)e);
                throw new VOMSException("Certificate parsing error while updating trusted CA org.glite.security.voms.admin.database!", e);
            }
            catch (IOException e) {
                log.error((Object)"File access error while updating trusted CA org.glite.security.voms.admin.database!", (Throwable)e);
                throw new VOMSException("File access error while updating trusted CA org.glite.security.voms.admin.database!", e);
            }
            catch (VOMSDatabaseException e) {
                log.error((Object)"Error updating trusted CA org.glite.security.voms.admin.database!", (Throwable)e);
                throw new VOMSException("Error updating trusted CA org.glite.security.voms.admin.database!", e);
            }
        }
    }
}

