/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.dao;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.glite.security.voms.admin.common.NullArgumentException;
import org.glite.security.voms.admin.dao.VOMSAdminDAO;
import org.glite.security.voms.admin.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.glite.security.voms.admin.model.ACL;
import org.glite.security.voms.admin.model.VOMSAdmin;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSRole;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;

public class ACLDAO {
    private ACLDAO() {
        HibernateFactory.beginTransaction();
    }

    public ACL getById(Long id) {
        return (ACL)HibernateFactory.getSession().load(ACL.class, (Serializable)id);
    }

    public ACL create(VOMSGroup g, boolean isDefault) {
        if (g == null) {
            throw new NullArgumentException("Cannot create an ACL for a null group!");
        }
        ACL acl = new ACL(g, isDefault);
        HibernateFactory.getSession().save((Object)acl);
        g.getAcls().add(acl);
        HibernateFactory.getSession().save((Object)g);
        return acl;
    }

    public void delete(ACL acl) {
        if (acl == null) {
            throw new NullArgumentException("Cannot delete a null ACL!");
        }
        VOMSContext context = acl.getContext();
        if (context.isGroupContext() && acl.isDefautlACL() && acl.getPermissions().isEmpty()) {
            context.getGroup().getAcls().remove(acl);
            HibernateFactory.getSession().delete((Object)acl);
            HibernateFactory.getSession().update((Object)context.getGroup());
        }
    }

    public void deletePermissionsForRole(VOMSRole r) {
        List roleAdmins = VOMSAdminDAO.instance().getRoleAdmins(r);
        Iterator i = roleAdmins.iterator();
        while (i.hasNext()) {
            this.deletePermissionsForAdmin((VOMSAdmin)i.next());
        }
    }

    public void deletePermissionsForAdmin(VOMSAdmin a) {
        String query = "select a from org.glite.security.voms.admin.model.ACL a join a.permissions where admin_id = :adminId";
        Iterator i = HibernateFactory.getSession().createQuery(query).setLong("adminId", a.getId().longValue()).iterate();
        while (i.hasNext()) {
            ACL acl = (ACL)i.next();
            acl.removePermissions(a);
            HibernateFactory.getSession().save((Object)acl);
        }
    }

    public boolean hasActivePermissions(VOMSAdmin a) {
        String query = "select count(*) from org.glite.security.voms.admin.model.ACL a join a.permissions where admin_id = :adminId";
        Long count = (Long)HibernateFactory.getSession().createQuery(query).setLong("adminId", a.getId().longValue()).uniqueResult();
        return count > 0L;
    }

    public void recursiveSaveACLEntry(ACL acl, VOMSAdmin admin, VOMSPermission perms) {
        if (acl == null) {
            throw new NullArgumentException("acl cannot be null!");
        }
        if (admin == null) {
            throw new NullArgumentException("admin cannot be null!");
        }
        if (perms == null) {
            throw new NullArgumentException("perms cannot be null!");
        }
        this.saveACLEntry(acl, admin, perms);
        if (acl.getContext().isGroupContext() && !acl.isDefautlACL()) {
            List childrenGroups = VOMSGroupDAO.instance().getChildren(acl.getGroup());
            for (VOMSGroup childGroup : childrenGroups) {
                this.recursiveSaveACLEntry(childGroup.getACL(), admin, perms);
            }
        }
    }

    public void saveACLEntry(ACL acl, VOMSAdmin admin, VOMSPermission perms) {
        if (acl == null) {
            throw new NullArgumentException("acl cannot be null!");
        }
        if (admin == null) {
            throw new NullArgumentException("admin cannot be null!");
        }
        if (perms == null) {
            throw new NullArgumentException("perms cannot be null!");
        }
        acl.setPermissions(admin, perms);
        HibernateFactory.getSession().save((Object)acl);
        if (acl.getContext().isGroupContext()) {
            List roles = VOMSRoleDAO.instance().getAll();
            for (VOMSRole childRole : roles) {
                ACL childRoleACL = childRole.getACL(acl.getGroup());
                childRoleACL.setPermissions(admin, perms);
                HibernateFactory.getSession().save((Object)childRoleACL);
            }
        }
    }

    public void recursiveDeleteACLEntry(ACL acl, VOMSAdmin admin) {
        if (acl == null) {
            throw new NullArgumentException("acl cannot be null!");
        }
        if (admin == null) {
            throw new NullArgumentException("admin cannot be null!");
        }
        if (acl.getContext().isGroupContext() && !acl.isDefautlACL()) {
            List childrenGroups = VOMSGroupDAO.instance().getChildren(acl.getGroup());
            for (VOMSGroup childGroup : childrenGroups) {
                this.recursiveDeleteACLEntry(childGroup.getACL(), admin);
            }
        }
        this.deleteACLEntry(acl, admin);
    }

    public void deleteACLEntry(ACL acl, VOMSAdmin admin) {
        if (acl == null) {
            throw new NullArgumentException("acl cannot be null!");
        }
        if (admin == null) {
            throw new NullArgumentException("admin cannot be null!");
        }
        acl.removePermissions(admin);
        if (acl.getPermissions().isEmpty() && acl.isDefautlACL()) {
            ACLDAO.instance().delete(acl);
        } else {
            HibernateFactory.getSession().save((Object)acl);
        }
        if (acl.getContext().isGroupContext()) {
            List roles = VOMSRoleDAO.instance().getAll();
            for (VOMSRole childRole : roles) {
                ACL childRoleACL = childRole.getACL(acl.getGroup());
                childRoleACL.removePermissions(admin);
                HibernateFactory.getSession().save((Object)childRoleACL);
            }
        }
    }

    public void checkAdmin(VOMSAdmin a) {
        if (a.isInternalAdmin()) {
            return;
        }
    }

    public static ACLDAO instance() {
        return new ACLDAO();
    }
}

