/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.dao;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.operations.CurrentAdmin;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;

public class DAOUtils {
    private static final Log log = LogFactory.getLog(DAOUtils.class);

    public static boolean hasPermissionOnPath(VOMSGroup g, VOMSPermission requiredPermission) {
        VOMSGroup parent = g.getParent();
        CurrentAdmin admin = CurrentAdmin.instance();
        do {
            if (admin.hasPermissions(VOMSContext.instance(parent), requiredPermission)) continue;
            return false;
        } while (!(parent = parent.getParent()).isRootGroup());
        return true;
    }

    public static List filterGroupList(List results, VOMSPermission requiredPermission) {
        Iterator i = results.iterator();
        while (i.hasNext()) {
            VOMSGroup group = (VOMSGroup)i.next();
            if (DAOUtils.hasPermissionOnPath(group, requiredPermission)) continue;
            log.debug((Object)("Filtering out \"" + group + "\" from search results since current admin doesn't have " + requiredPermission + " permissions in the parent group."));
            i.remove();
        }
        return results;
    }
}

