/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.dao;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.admin.common.DNUtil;
import org.glite.security.voms.admin.common.NullArgumentException;
import org.glite.security.voms.admin.common.PathNamingScheme;
import org.glite.security.voms.admin.dao.VOMSCADAO;
import org.glite.security.voms.admin.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.glite.security.voms.admin.database.NoSuchCAException;
import org.glite.security.voms.admin.database.VOMSDatabaseException;
import org.glite.security.voms.admin.model.VOMSAdmin;
import org.glite.security.voms.admin.model.VOMSCA;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSRole;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.hibernate.Query;

public class VOMSAdminDAO {
    public static final Log log = LogFactory.getLog(VOMSAdminDAO.class);

    protected VOMSAdminDAO() {
        HibernateFactory.beginTransaction();
    }

    public static VOMSAdminDAO instance() {
        return new VOMSAdminDAO();
    }

    public List getAll() {
        String query = "from org.glite.security.voms.admin.model.VOMSAdmin";
        List result = HibernateFactory.getSession().createQuery(query).list();
        return result;
    }

    public VOMSAdmin getAnyAuthenticatedUserAdmin() {
        String query = "from org.glite.security.voms.admin.model.VOMSAdmin as a where a.dn = :dn and a.ca.dn = :caDN";
        Query q = HibernateFactory.getSession().createQuery(query);
        q.setString("dn", "/O=VOMS/O=System/CN=Any Authenticated User");
        q.setString("caDN", "/O=VOMS/O=System/CN=Dummy Certificate Authority");
        VOMSAdmin a = (VOMSAdmin)q.uniqueResult();
        if (a == null) {
            throw new VOMSDatabaseException("Database corrupted! ANYUSER_ADMIN not found in admins table!");
        }
        return a;
    }

    public VOMSAdmin getById(Long id) {
        if (id == null) {
            throw new NullArgumentException("id must be non-null!");
        }
        return (VOMSAdmin)HibernateFactory.getSession().load(VOMSAdmin.class, (Serializable)id);
    }

    public VOMSAdmin getByName(String dn, String caDN) {
        if (dn == null) {
            throw new NullArgumentException("dn must be non-null!");
        }
        if (caDN == null) {
            throw new NullArgumentException("caDN must be non-null!");
        }
        dn = DNUtil.normalizeDN(dn);
        caDN = DNUtil.normalizeDN(caDN);
        String query = "from org.glite.security.voms.admin.model.VOMSAdmin as a where a.dn = :dn and a.ca.dn = :caDN";
        Query q = HibernateFactory.getSession().createQuery(query);
        q.setString("dn", dn);
        q.setString("caDN", caDN);
        return (VOMSAdmin)q.uniqueResult();
    }

    public List getRoleAdmins(VOMSRole r) {
        String searchString = "%Role=" + r.getName();
        String query = "from org.glite.security.voms.admin.model.VOMSAdmin where dn like :searchString";
        return HibernateFactory.getSession().createQuery(query).setString("searchString", searchString).list();
    }

    public void deleteRoleAdmins(VOMSRole r) {
        String searchString = "%Role=" + r.getName();
        String query = "from org.glite.security.voms.admin.model.VOMSAdmin where dn like :searchString";
        Iterator i = HibernateFactory.getSession().createQuery(query).setString("searchString", searchString).iterate();
        while (i.hasNext()) {
            VOMSAdmin a = (VOMSAdmin)i.next();
            this.delete(a);
        }
    }

    public VOMSAdmin getByFQAN(String fqan) {
        if (fqan == null) {
            throw new NullArgumentException("fqan must be non-null!");
        }
        if (PathNamingScheme.isGroup(fqan)) {
            return this.getByName(fqan, "/O=VOMS/O=System/CN=VOMS Group");
        }
        if (PathNamingScheme.isQualifiedRole(fqan)) {
            return this.getByName(fqan, "/O=VOMS/O=System/CN=VOMS Role");
        }
        return null;
    }

    public VOMSAdmin create(String fqan) {
        if (fqan == null) {
            throw new NullArgumentException("fqan must be non-null!");
        }
        PathNamingScheme.checkSyntax(fqan);
        VOMSAdmin admin = new VOMSAdmin();
        admin.setDn(fqan);
        if (PathNamingScheme.isGroup(fqan)) {
            admin.setCa(VOMSCADAO.instance().getGroupCA());
        } else if (PathNamingScheme.isQualifiedRole(fqan)) {
            admin.setCa(VOMSCADAO.instance().getRoleCA());
        }
        HibernateFactory.getSession().save((Object)admin);
        return admin;
    }

    public VOMSAdmin create(String dn, String caDN) {
        return this.create(dn, caDN, null);
    }

    public VOMSAdmin create(String dn, String caDN, String emailAddress) {
        if (dn == null) {
            throw new NullArgumentException("dn must be non-null!");
        }
        if (caDN == null) {
            throw new NullArgumentException("caDN must be non-null!");
        }
        caDN = DNUtil.normalizeDN(caDN);
        VOMSAdmin admin = new VOMSAdmin();
        VOMSCA ca = VOMSCADAO.instance().getByName(caDN);
        if (ca == null) {
            throw new IllegalArgumentException("Unkown CA " + caDN + " passed as argument!");
        }
        dn = DNUtil.normalizeDN(dn);
        admin.setDn(dn);
        admin.setCa(ca);
        admin.setEmailAddress(emailAddress);
        HibernateFactory.getSession().save((Object)admin);
        return admin;
    }

    public VOMSAdmin create(VOMSAdmin admin) {
        if (admin == null) {
            throw new NullArgumentException("admin must not be null!");
        }
        admin.setDn(DNUtil.normalizeDN(admin.getDn()));
        HibernateFactory.getSession().save((Object)admin);
        return admin;
    }

    public void delete(VOMSAdmin admin) {
        if (admin == null) {
            throw new NullArgumentException("admin must not be null!");
        }
        HibernateFactory.getSession().delete((Object)admin);
    }

    public void delete(String dn, String caDN) {
        if (dn == null) {
            throw new NullArgumentException("dn must be non-null!");
        }
        if (caDN == null) {
            throw new NullArgumentException("caDN must be non-null!");
        }
        VOMSCA ca = VOMSCADAO.instance().getByName(caDN);
        if (ca == null) {
            throw new NoSuchCAException("Unknown CA '" + caDN + "'.");
        }
        Query q = HibernateFactory.getSession().createQuery("delete from org.glite.security.voms.admin.model.VOMSAdmin where dn = :dn and ca =:ca").setString("dn", dn).setParameter("ca", (Object)ca);
        q.executeUpdate();
    }

    public VOMSAdmin createAuthorizedAdmin(String dn, String caDN) {
        VOMSAdmin admin = this.create(dn, caDN);
        VOMSGroup g = VOMSGroupDAO.instance().getVOGroup();
        if (g == null) {
            throw new VOMSDatabaseException("Vo group still undefined in org.glite.security.voms.admin.database!");
        }
        g.getACL().setPermissions(admin, VOMSPermission.getAllPermissions());
        HibernateFactory.getSession().save((Object)admin);
        HibernateFactory.getSession().save((Object)g);
        return admin;
    }

    public void saveOrUpdate(VOMSAdmin a) {
        HibernateFactory.getSession().saveOrUpdate((Object)a);
    }

    public void update(VOMSAdmin a) {
        HibernateFactory.getSession().update((Object)a);
    }
}

