/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.dao;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.admin.common.NullArgumentException;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.glite.security.voms.admin.model.VOMSCA;
import org.hibernate.Session;

public class VOMSCADAO {
    public static final Log log = LogFactory.getLog(VOMSCADAO.class);

    private VOMSCADAO() {
        HibernateFactory.beginTransaction();
    }

    public VOMSCA createCA(String caDN, String description) {
        if (caDN == null) {
            throw new NullArgumentException("caDN must be non-null!");
        }
        VOMSCA ca = new VOMSCA(caDN, description);
        HibernateFactory.getSession().save((Object)ca);
        return ca;
    }

    public void saveTrustedCA(String caDN) {
        Session sess = HibernateFactory.getSession();
        VOMSCA ca = this.getByName(caDN);
        if (ca == null) {
            log.debug((Object)("Adding [ " + caDN + "] to trusted CA database."));
            this.createCA(caDN, null);
        } else {
            log.debug((Object)(caDN + " is already in trusted CA database."));
        }
    }

    public VOMSCA getByName(String caDN) {
        if (caDN == null) {
            throw new NullArgumentException("caDN must be non-null!");
        }
        String queryString = "from org.glite.security.voms.admin.model.VOMSCA as ca where ca.dn = :caDN";
        VOMSCA res = (VOMSCA)HibernateFactory.getSession().createQuery(queryString).setString("caDN", caDN).uniqueResult();
        return res;
    }

    public VOMSCA getByID(Short caID) {
        return (VOMSCA)HibernateFactory.getSession().get(VOMSCA.class, (Serializable)caID);
    }

    public VOMSCA getByID(short caID) {
        return this.getByID(new Short(caID));
    }

    public List getAll() {
        String query = "from org.glite.security.voms.admin.model.VOMSCA";
        List res = HibernateFactory.getSession().createQuery(query).list();
        return res;
    }

    public List getValid() {
        String query = "from org.glite.security.voms.admin.model.VOMSCA where dn not like '/O=VOMS%'";
        List res = HibernateFactory.getSession().createQuery(query).list();
        return res;
    }

    public VOMSCA getGroupCA() {
        return this.getByName("/O=VOMS/O=System/CN=VOMS Group");
    }

    public VOMSCA getRoleCA() {
        return this.getByName("/O=VOMS/O=System/CN=VOMS Role");
    }

    public static VOMSCADAO instance() {
        return new VOMSCADAO();
    }
}

