/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.dao;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.admin.common.NullArgumentException;
import org.glite.security.voms.admin.common.PathNamingScheme;
import org.glite.security.voms.admin.common.VOMSConfiguration;
import org.glite.security.voms.admin.common.VOMSConfigurationException;
import org.glite.security.voms.admin.common.VOMSSyntaxException;
import org.glite.security.voms.admin.dao.DAOUtils;
import org.glite.security.voms.admin.dao.SearchResults;
import org.glite.security.voms.admin.dao.VOMSAttributeDAO;
import org.glite.security.voms.admin.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.database.AlreadyExistsException;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.glite.security.voms.admin.database.IllegalOperationException;
import org.glite.security.voms.admin.database.NoSuchAttributeException;
import org.glite.security.voms.admin.database.NoSuchGroupException;
import org.glite.security.voms.admin.database.VOMSDatabaseException;
import org.glite.security.voms.admin.database.VOMSInconsistentDatabaseException;
import org.glite.security.voms.admin.model.VOMSAttributeDescription;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSGroupAttribute;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;

public class VOMSGroupDAO {
    public static final Log log = LogFactory.getLog(VOMSGroupDAO.class);

    private VOMSGroupDAO() {
        HibernateFactory.beginTransaction();
    }

    public List getAll() {
        String query = "from org.glite.security.voms.admin.model.VOMSGroup order by name asc";
        Query q = HibernateFactory.getSession().createQuery(query);
        List res = q.list();
        return DAOUtils.filterGroupList(res, VOMSPermission.getContainerReadPermission());
    }

    public int countMatches(String searchString) {
        String sString = "%" + searchString + "%";
        String cQueryString = "select count(*) from org.glite.security.voms.admin.model.VOMSGroup where name like :searchString";
        Long totalMatches = (Long)HibernateFactory.getSession().createQuery(cQueryString).setString("searchString", sString).uniqueResult();
        return totalMatches.intValue();
    }

    public int countGroups() {
        Long count = (Long)HibernateFactory.getSession().createQuery("select count(*) from org.glite.security.voms.admin.model.VOMSGroup").uniqueResult();
        return count.intValue();
    }

    public List findAll() {
        String query = "from org.glite.security.voms.admin.model.VOMSGroup";
        Query q = HibernateFactory.getSession().createQuery(query);
        return q.list();
    }

    public SearchResults getAll(int firstResult, int maxResults) {
        SearchResults results = SearchResults.instance();
        String query = "from org.glite.security.voms.admin.model.VOMSGroup order by name asc";
        Query q = HibernateFactory.getSession().createQuery(query);
        q.setFirstResult(firstResult);
        q.setMaxResults(maxResults);
        List res = DAOUtils.filterGroupList(q.list(), VOMSPermission.getContainerReadPermission());
        results.setCount(this.countGroups());
        results.setFirstResult(firstResult);
        results.setResultsPerPage(maxResults);
        results.setResults(res);
        return results;
    }

    public SearchResults search(String searchString, int firstResult, int maxResults) {
        if (searchString == null || searchString.equals("") || searchString.length() == 0) {
            return this.getAll(firstResult, maxResults);
        }
        SearchResults results = SearchResults.instance();
        String sString = "%" + searchString + "%";
        String queryString = "from org.glite.security.voms.admin.model.VOMSGroup where name like :searchString order by name asc";
        Query q = HibernateFactory.getSession().createQuery(queryString).setString("searchString", sString);
        q.setFirstResult(firstResult);
        q.setMaxResults(maxResults);
        List res = DAOUtils.filterGroupList(q.list(), VOMSPermission.getContainerReadPermission());
        results.setSearchString(searchString);
        results.setResults(res);
        results.setCount(this.countMatches(searchString));
        results.setFirstResult(firstResult);
        results.setResultsPerPage(maxResults);
        return results;
    }

    public SearchResults getMembers(VOMSGroup g, int firstResult, int maxResults) {
        int count = g.getMembers().size();
        SearchResults results = SearchResults.instance();
        String queryString = "select m.user as user from org.glite.security.voms.admin.model.VOMSMapping m where m.group = :group and m.role is null";
        Query q = HibernateFactory.getSession().createQuery(queryString).setFirstResult(firstResult).setMaxResults(maxResults);
        q.setEntity("group", (Object)g);
        List res = q.list();
        results.setSearchString(null);
        results.setResults(res);
        results.setCount(count);
        results.setFirstResult(firstResult);
        results.setResultsPerPage(maxResults);
        return results;
    }

    public int countMatchingMembers(VOMSGroup g, String searchString) {
        if (g == null) {
            throw new NullArgumentException("Cannot search members in a null group!");
        }
        String sString = "%" + searchString + "%";
        String queryString = "select count(m.user) from org.glite.security.voms.admin.model.VOMSMapping m where m.group = :group and m.role is null and m.user.dn like :searchString";
        Query q = HibernateFactory.getSession().createQuery(queryString).setString("searchString", sString);
        q.setEntity("group", (Object)g);
        return ((Long)q.uniqueResult()).intValue();
    }

    public SearchResults searchMembers(VOMSGroup g, String searchString, int firstResult, int maxResults) {
        if (g == null) {
            throw new NullArgumentException("Cannot search members in a null group!");
        }
        if (searchString == null || searchString.equals("") || searchString.length() == 0) {
            return this.getMembers(g, firstResult, maxResults);
        }
        SearchResults results = SearchResults.instance();
        String sString = "%" + searchString + "%";
        String queryString = "select m.user as user from org.glite.security.voms.admin.model.VOMSMapping m where m.group = :group and m.role is null and (m.user.dn like :searchString or m.user.ca.dn like :searchString) order by m.user.dn asc";
        Query q = HibernateFactory.getSession().createQuery(queryString).setString("searchString", sString);
        q.setEntity("group", (Object)g);
        q.setFirstResult(firstResult);
        q.setMaxResults(maxResults);
        List res = q.list();
        results.setSearchString(searchString);
        results.setResults(res);
        results.setCount(this.countMatchingMembers(g, searchString));
        results.setFirstResult(firstResult);
        results.setResultsPerPage(maxResults);
        return results;
    }

    public VOMSGroup findByName(String name) {
        if (!PathNamingScheme.isGroup(name)) {
            throw new VOMSSyntaxException("Syntax error in group name: " + name);
        }
        String query = "from org.glite.security.voms.admin.model.VOMSGroup as g where g.name =:groupName";
        Query q = HibernateFactory.getSession().createQuery(query);
        q.setString("groupName", name);
        VOMSGroup g = (VOMSGroup)q.uniqueResult();
        return g;
    }

    public VOMSGroup findById(Long id) {
        VOMSGroup g = (VOMSGroup)HibernateFactory.getSession().load(VOMSGroup.class, (Serializable)id);
        return g;
    }

    public VOMSGroup getVOGroup() {
        VOMSConfiguration conf = VOMSConfiguration.instance();
        String voName = conf.getString("voms.vo.name");
        if (voName == null) {
            throw new VOMSConfigurationException("voms.vo.nameundefined in configuration!");
        }
        VOMSGroup g = this.findByName("/" + voName);
        if (g == null) {
            throw new VOMSInconsistentDatabaseException("VO root group undefined in org.glite.security.voms.admin.database!");
        }
        return g;
    }

    public List getChildren(VOMSGroup parentGroup) {
        String query = "from org.glite.security.voms.admin.model.VOMSGroup g where g.parent = :parentGroup and g != :parentGroup order by g.name";
        Query q = HibernateFactory.getSession().createQuery(query);
        q.setEntity("parentGroup", (Object)parentGroup);
        return q.list();
    }

    public VOMSGroup create(String groupName) {
        String rootGroupName;
        if (!PathNamingScheme.isGroup(groupName)) {
            throw new VOMSSyntaxException("Syntax error in group name: " + groupName);
        }
        if (this.findByName(groupName) != null) {
            throw new AlreadyExistsException("Group \"" + groupName + "\" already defined!");
        }
        String[] parentGroupChain = PathNamingScheme.getParentGroupChain(groupName);
        if (!parentGroupChain[0].equals(rootGroupName = this.getVOGroup().getName())) {
            throw new IllegalArgumentException("The root group for \"" + groupName + "\" must match the root group of the VO (i.e., " + rootGroupName + ")");
        }
        String parentGroupName = PathNamingScheme.getParentGroupName(groupName);
        VOMSGroup parentGroup = this.findByName(parentGroupName);
        if (parentGroup == null) {
            throw new NoSuchGroupException("Parent group \"" + parentGroupName + "\" not defined in org.glite.security.voms.admin.database!");
        }
        VOMSGroup newGroup = new VOMSGroup();
        newGroup.setName(groupName);
        newGroup.setParent(parentGroup);
        log.debug((Object)("Creating group \"" + newGroup + "\"."));
        HibernateFactory.getSession().save((Object)newGroup);
        return newGroup;
    }

    public void delete(Long id) {
        VOMSGroup g = this.findById(id);
        if (g == null) {
            throw new NoSuchGroupException("Group with id \"" + id + "\" not defined!");
        }
        try {
            this.delete(g);
        }
        catch (ObjectNotFoundException e) {
            throw new NoSuchGroupException("Group with id \"" + id + "\" not defined!");
        }
    }

    private void uncheckedDelete(VOMSGroup g) {
        if (!g.isRootGroup()) {
            g.getMappings().clear();
            g.getAttributes().clear();
            HibernateFactory.getSession().delete((Object)g);
        }
    }

    public void deleteAll() {
        Iterator groups = this.getAll().iterator();
        while (groups.hasNext()) {
            this.uncheckedDelete((VOMSGroup)groups.next());
        }
    }

    public void delete(VOMSGroup g) {
        if (!PathNamingScheme.isGroup(g.getName())) {
            throw new VOMSSyntaxException("Syntax error in group name for group: " + g);
        }
        if (g.isRootGroup() && g.equals(this.getVOGroup())) {
            throw new IllegalOperationException("VO root group \"" + g.getName() + "\" cannot be deleted!");
        }
        if (this.findByName(g.getName()) == null) {
            throw new NoSuchGroupException("Group \"" + g + "\" not defined!");
        }
        List children = this.getChildren(g);
        if (!children.isEmpty()) {
            throw new IllegalOperationException("The group \"" + g + "\" cannot be deleted since it contains subgroups. Delete subgroups first.");
        }
        log.debug((Object)("Deleting group " + g + "\"."));
        VOMSRoleDAO.instance().removeRoleAttributesForGroup(g);
        g.getMappings().clear();
        g.getAcls().clear();
        HibernateFactory.getSession().delete((Object)g);
        HibernateFactory.getSession().flush();
    }

    public VOMSGroup createVOGroup() {
        VOMSConfiguration conf = VOMSConfiguration.instance();
        String voName = conf.getVOName();
        if (voName == null) {
            throw new VOMSConfigurationException("voms.vo.name undefined in configuration!");
        }
        VOMSGroup g = this.findByName("/" + voName);
        if (g != null) {
            throw new VOMSDatabaseException("Root group already defined for vo " + voName);
        }
        g = new VOMSGroup();
        g.setName("/" + voName);
        g.setId(new Long(1L));
        try {
            HibernateFactory.getSession().save((Object)g);
            HibernateFactory.commitTransaction();
            HibernateFactory.beginTransaction();
            g.setParent(g);
            HibernateFactory.getSession().update((Object)g);
            HibernateFactory.commitTransaction();
        }
        catch (HibernateException e) {
            throw new VOMSDatabaseException("Failed creation of VO root group!", e);
        }
        finally {
            HibernateFactory.commitTransaction();
        }
        return g;
    }

    public VOMSGroupAttribute setAttribute(VOMSGroup g, String attrName, String attrValue) {
        VOMSAttributeDescription desc = VOMSAttributeDAO.instance().getAttributeDescriptionByName(attrName);
        if (desc == null) {
            throw new NoSuchAttributeException("Attribute '" + attrName + "' is not defined in this vo.");
        }
        VOMSGroupAttribute val = g.getAttributeByName(attrName);
        if (val != null) {
            val.setValue(attrValue);
        } else {
            val = VOMSGroupAttribute.instance(desc, attrValue, g);
            g.addAttribute(val);
        }
        HibernateFactory.getSession().update((Object)g);
        return val;
    }

    public VOMSGroupAttribute createAttribute(VOMSGroup g, String attrName, String attrDesc, String attrValue) {
        if (g.getAttributeByName(attrName) != null) {
            throw new AlreadyExistsException("Attribute \"" + attrName + "\" already defined for group \"" + g + "\".");
        }
        VOMSAttributeDescription desc = VOMSAttributeDAO.instance().getAttributeDescriptionByName(attrName);
        if (desc == null) {
            desc = VOMSAttributeDAO.instance().createAttributeDescription(attrName, attrDesc);
        }
        log.debug((Object)("Creating attribute \"(" + attrName + "," + attrValue + ")\" for group \"" + g + "\""));
        VOMSGroupAttribute val = VOMSGroupAttribute.instance(desc, attrValue, g);
        g.addAttribute(val);
        return val;
    }

    public void deleteAttribute(VOMSGroup g, String attrName) {
        VOMSGroupAttribute ga = g.getAttributeByName(attrName);
        if (ga == null) {
            throw new NoSuchAttributeException("Attribute named '" + attrName + "' not defined for group '" + g.getName() + "'!");
        }
        this.deleteAttribute(g, ga);
    }

    public void deleteAttribute(VOMSGroup g, VOMSGroupAttribute val) {
        log.debug((Object)("Deleting attribute \"" + val.getName() + "\" from group \"" + g + "\""));
        g.deleteAttribute(val);
    }

    public boolean isVOGroup(VOMSGroup g) {
        return g.equals(this.getVOGroup());
    }

    public static VOMSGroupDAO instance() {
        return new VOMSGroupDAO();
    }

    public List getMembers(VOMSGroup g) {
        if (g == null) {
            throw new NullArgumentException("Cannot get members of a null group!");
        }
        String query = "select m.user from org.glite.security.voms.admin.model.VOMSMapping m where m.group = :group and m.role is null";
        return HibernateFactory.getSession().createQuery(query).setEntity("group", (Object)g).list();
    }

    public Object getMemberNames(VOMSGroup g) {
        if (g == null) {
            throw new NullArgumentException("Cannot get members of a null group!");
        }
        String query = "select distinct m.user.dn from org.glite.security.voms.admin.model.VOMSMapping m where m.group = :group and m.role is null";
        return HibernateFactory.getSession().createQuery(query).setEntity("group", (Object)g).list();
    }
}

