/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.admin.common.DNUtil;
import org.glite.security.voms.admin.common.NullArgumentException;
import org.glite.security.voms.admin.dao.SearchResults;
import org.glite.security.voms.admin.dao.VOMSAttributeDAO;
import org.glite.security.voms.admin.dao.VOMSCADAO;
import org.glite.security.voms.admin.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.database.AlreadyMemberException;
import org.glite.security.voms.admin.database.AttributeAlreadyExistsException;
import org.glite.security.voms.admin.database.AttributeValueAlreadyAssignedException;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.glite.security.voms.admin.database.NoSuchAttributeException;
import org.glite.security.voms.admin.database.NoSuchCAException;
import org.glite.security.voms.admin.database.NoSuchGroupException;
import org.glite.security.voms.admin.database.NoSuchUserException;
import org.glite.security.voms.admin.database.UserAlreadyExistsException;
import org.glite.security.voms.admin.model.VOMSAttributeDescription;
import org.glite.security.voms.admin.model.VOMSCA;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSMapping;
import org.glite.security.voms.admin.model.VOMSRole;
import org.glite.security.voms.admin.model.VOMSUser;
import org.glite.security.voms.admin.model.VOMSUserAttribute;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;

public class VOMSUserDAO {
    private static final Log log = LogFactory.getLog(VOMSUserDAO.class);

    private VOMSUserDAO() {
    }

    public List getAll() {
        Query q = HibernateFactory.getSession().createQuery("select u from VOMSUser u order by u.dn asc");
        List result = q.list();
        return result;
    }

    public List getUnsubscribedGroups(Long userId) {
        VOMSUser u = this.findById(userId);
        ArrayList<VOMSGroup> result = new ArrayList<VOMSGroup>();
        for (VOMSGroup g : VOMSGroupDAO.instance().getAll()) {
            if (u.isMember(g)) continue;
            result.add(g);
        }
        return result;
    }

    public List getUnAssignedRoles(Long userId, Long groupId) {
        VOMSUser u = this.findById(userId);
        VOMSGroup g = VOMSGroupDAO.instance().findById(groupId);
        ArrayList<VOMSRole> result = new ArrayList<VOMSRole>();
        for (VOMSRole r : VOMSRoleDAO.instance().getAll()) {
            if (u.hasRole(g, r)) continue;
            result.add(r);
        }
        return result;
    }

    public SearchResults getAll(int firstResults, int maxResults) {
        SearchResults res = SearchResults.instance();
        Query q = HibernateFactory.getSession().createQuery("from VOMSUser as u order by u.dn asc");
        q.setFirstResult(firstResults);
        q.setMaxResults(maxResults);
        res.setCount(this.countUsers());
        res.setResults(q.list());
        res.setFirstResult(firstResults);
        res.setResultsPerPage(maxResults);
        return res;
    }

    public int countMatches(String searchString) {
        String sString = "%" + searchString + "%";
        String countString = "select count(distinct u) from VOMSUser u where u.dn like :searchString or u.ca.dn like :searchString or u.emailAddress like :searchString";
        Query q = HibernateFactory.getSession().createQuery(countString);
        q.setString("searchString", sString);
        Long count = (Long)q.uniqueResult();
        return count.intValue();
    }

    public SearchResults search(String searchString, int firstResults, int maxResults) {
        log.debug((Object)("searchString:" + searchString + ",firstResults: " + firstResults + ",maxResults: " + maxResults));
        if (searchString == null || searchString.equals("") || searchString.length() == 0) {
            return this.getAll(firstResults, maxResults);
        }
        SearchResults res = SearchResults.instance();
        String sString = "%" + searchString + "%";
        String queryString = "select distinct u from VOMSUser u where u.dn like :searchString or u.ca.dn like :searchString or u.emailAddress like :searchString order by u.dn asc";
        Query q = HibernateFactory.getSession().createQuery(queryString);
        q.setString("searchString", sString);
        q.setFirstResult(firstResults);
        q.setMaxResults(maxResults);
        res.setCount(this.countMatches(searchString));
        res.setFirstResult(firstResults);
        res.setResultsPerPage(maxResults);
        res.setResults(q.list());
        res.setSearchString(searchString);
        return res;
    }

    public int countUsers() {
        Query q = HibernateFactory.getSession().createQuery("select count(*) from VOMSUser");
        Long count = (Long)q.uniqueResult();
        return count.intValue();
    }

    public VOMSUser getByName(String userDN, VOMSCA ca) {
        if (userDN == null) {
            throw new NullArgumentException("Cannot find a user by name given a null userDN!");
        }
        if (ca == null) {
            throw new NullArgumentException("Cannot find a user by name and ca given a null ca!");
        }
        return this.getByName(userDN, ca.getDn());
    }

    public VOMSUser getByName(String userDN, String caDN) {
        String queryString = "from org.glite.security.voms.admin.model.VOMSUser where dn = :userDN and ca.dn = :caDN";
        Query q = HibernateFactory.getSession().createQuery(queryString);
        q.setString("userDN", userDN);
        q.setString("caDN", caDN);
        return (VOMSUser)q.uniqueResult();
    }

    public List getAllNames() {
        String query = "select dn, ca.dn from org.glite.security.voms.admin.model.VOMSUser";
        return HibernateFactory.getSession().createQuery(query).list();
    }

    public VOMSUser findByName(String dn, String caDN) {
        if (dn == null) {
            throw new NullArgumentException("dn must be non-null!");
        }
        if (caDN == null) {
            throw new NullArgumentException("ca must be non-null!");
        }
        String query = "from org.glite.security.voms.admin.model.VOMSUser as u  where u.dn = :dn and u.ca.dn = :caDN";
        Query q = HibernateFactory.getSession().createQuery(query);
        q.setString("dn", dn);
        q.setString("caDN", caDN);
        VOMSUser result = (VOMSUser)q.uniqueResult();
        return result;
    }

    public VOMSUser findById(Long userId) {
        return (VOMSUser)HibernateFactory.getSession().get(VOMSUser.class, (Serializable)userId);
    }

    public VOMSUser findByEmail(String emailAddress) {
        if (emailAddress == null) {
            throw new NullArgumentException("emailAddress must be non-null!");
        }
        String query = "from org.glite.security.voms.admin.model.VOMSUser as u  where u.emailAddress = :emailAddress";
        Query q = HibernateFactory.getSession().createQuery(query);
        q.setString("emailAddress", emailAddress);
        VOMSUser result = (VOMSUser)q.uniqueResult();
        return result;
    }

    public VOMSUser create(VOMSUser usr, String caDN) {
        if (usr.getDn() == null || "".equals(usr.getDn())) {
            throw new NullArgumentException("dn must be non-null!");
        }
        caDN = DNUtil.normalizeDN(caDN);
        VOMSCA ca = VOMSCADAO.instance().getByName(caDN);
        if (ca == null) {
            throw new NullArgumentException("CA " + caDN + " does not exist in database!");
        }
        usr.setDn(DNUtil.normalizeDN(usr.getDn()));
        usr.setCa(ca);
        return this.create(usr);
    }

    public VOMSUser create(VOMSUser usr) {
        if (usr.getDn() == null) {
            throw new NullArgumentException("dn must be non-null!");
        }
        if (usr.getCa() == null) {
            throw new NullArgumentException("no ca specified for user!");
        }
        usr.setDn(DNUtil.normalizeDN(usr.getDn()));
        VOMSCA storedCA = VOMSCADAO.instance().getByName(usr.getCa().getDn());
        if (storedCA == null) {
            throw new NoSuchCAException("ca " + usr.getCa().getDn() + " does not exist in database!");
        }
        if (this.findByName(usr.getDn(), storedCA.getDn()) != null) {
            throw new UserAlreadyExistsException("User " + usr + " already exists in database!");
        }
        HibernateFactory.getSession().save((Object)usr);
        VOMSGroup voGroup = VOMSGroupDAO.instance().getVOGroup();
        this.addToGroup(usr, voGroup);
        HibernateFactory.getSession().save((Object)usr);
        HibernateFactory.getSession().save((Object)voGroup);
        return usr;
    }

    public VOMSUser create(String dn, String caDN, String cn, String certURI, String emailAddress) {
        if (dn == null) {
            throw new NullArgumentException("dn must be non-null!");
        }
        if (caDN == null) {
            throw new NullArgumentException("ca must be non-null!");
        }
        if (emailAddress == null) {
            throw new NullArgumentException("emailAddress must be non-null!");
        }
        VOMSUser u = this.findByName(dn, caDN);
        if (u != null) {
            throw new UserAlreadyExistsException("User " + u + " already in database!");
        }
        VOMSCA ca = VOMSCADAO.instance().getByName(caDN);
        if (ca == null) {
            throw new NoSuchCAException("Unknown ca " + caDN + ". Will not create user " + dn);
        }
        u = new VOMSUser();
        dn = DNUtil.normalizeDN(dn);
        u.setDn(dn);
        u.setCa(ca);
        u.setCn(cn);
        u.setCertURI(certURI);
        u.setEmailAddress(emailAddress);
        log.debug((Object)("Creating user \"" + u + "\"."));
        VOMSGroup voGroup = VOMSGroupDAO.instance().getVOGroup();
        HibernateFactory.getSession().save((Object)u);
        this.addToGroup(u, voGroup);
        return u;
    }

    public void delete(Long userId) {
        VOMSUser u = this.findById(userId);
        if (u == null) {
            throw new NoSuchUserException("User identified by \"" + userId + "\" not found in database!");
        }
        try {
            this.delete(u);
        }
        catch (ObjectNotFoundException e) {
            throw new NoSuchUserException("User identified by \"" + userId + "\" not found in database!");
        }
    }

    public void delete(VOMSUser u) {
        log.debug((Object)("Deleting user \"" + u + "\"."));
        if (this.getByName(u.getDn(), u.getCa().getDn()) == null) {
            throw new NoSuchUserException("User \"" + u + "\" is not defined in database!");
        }
        this.removeFromGroup(u, VOMSGroupDAO.instance().getVOGroup());
    }

    public VOMSUser update(VOMSUser u) {
        HibernateFactory.getSession().update((Object)u);
        return u;
    }

    public void addToGroup(VOMSUser u, VOMSGroup g) {
        VOMSUser checkUser;
        log.debug((Object)("Adding user \"" + u + "\" to group \"" + g + "\"."));
        if (!HibernateFactory.getSession().contains((Object)u) && (checkUser = this.findById(u.getId())) == null) {
            throw new NoSuchUserException("User \"" + u + "\" not found in database.");
        }
        if (VOMSGroupDAO.instance().findByName(g.getName()) == null) {
            throw new NoSuchGroupException("Group \"" + g + "\" is not defined in database.");
        }
        VOMSMapping m = new VOMSMapping(u, g, null);
        if (u.getMappings().contains(m)) {
            throw new AlreadyMemberException("User \"" + u + "\" is already a member of group \"" + g + "\".");
        }
        u.getMappings().add(m);
        HibernateFactory.getSession().save((Object)u);
    }

    public void removeFromGroup(VOMSUser u, VOMSGroup g) {
        log.debug((Object)("Removing user \"" + u + "\" from group \"" + g + "\"."));
        if (this.getByName(u.getDn(), u.getCa().getDn()) == null) {
            throw new NoSuchUserException("User \"" + u + "\" is not defined in database.");
        }
        if (VOMSGroupDAO.instance().findByName(g.getName()) == null) {
            throw new NoSuchGroupException("Group \"" + g + "\" is not defined in database.");
        }
        u.removeFromGroup(g);
        if (!g.isRootGroup()) {
            HibernateFactory.getSession().save((Object)u);
        } else {
            log.debug((Object)"Deleting user from database, since it is being removed from the VO root group.");
            u.getAttributes().clear();
            HibernateFactory.getSession().delete((Object)u);
        }
    }

    public VOMSUserAttribute setAttribute(VOMSUser u, String attrName, String attrValue) {
        VOMSAttributeDescription desc = VOMSAttributeDAO.instance().getAttributeDescriptionByName(attrName);
        if (desc == null) {
            throw new NoSuchAttributeException("Attribute '" + attrName + "' is not defined in this vo.");
        }
        if (!VOMSAttributeDAO.instance().isAttributeValueAlreadyAssigned(u, desc, attrValue)) {
            VOMSUserAttribute val = u.getAttributeByName(desc.getName());
            if (val == null) {
                val = VOMSUserAttribute.instance(desc, attrValue, u);
                u.addAttribute(val);
            } else {
                val.setValue(attrValue);
            }
            return val;
        }
        throw new AttributeValueAlreadyAssignedException("Value '" + attrValue + "' for attribute '" + attrName + "' has been already assigned to another user in this vo! Choose a different value.");
    }

    public VOMSUserAttribute createAttribute(VOMSUser u, String attrName, String attrDesc, String value) {
        if (u.getAttributeByName(attrName) != null) {
            throw new AttributeAlreadyExistsException("Attribute \"" + attrName + "\" already defined for user \"" + u + "\".");
        }
        VOMSAttributeDescription desc = VOMSAttributeDAO.instance().getAttributeDescriptionByName(attrName);
        if (desc == null) {
            desc = VOMSAttributeDAO.instance().createAttributeDescription(attrName, attrDesc);
        }
        log.debug((Object)("Creating attribute \"(" + attrName + "," + value + ")\" for user \"" + u + "\"."));
        VOMSUserAttribute val = VOMSUserAttribute.instance(desc, value, u);
        u.addAttribute(val);
        return val;
    }

    public void deleteAttribute(VOMSUser u, String attrName) {
        if (u.getAttributeByName(attrName) == null) {
            throw new NoSuchAttributeException("Attribute \"" + attrName + "\" not defined for user \"" + u + "\".");
        }
        log.debug((Object)("Deleting attribute \"" + attrName + "\" for user \"" + u + "\"."));
        u.deleteAttributeByName(attrName);
        HibernateFactory.getSession().update((Object)u);
    }

    public void assignRole(VOMSUser u, VOMSGroup g, VOMSRole r) {
        u.assignRole(g, r);
        HibernateFactory.getSession().update((Object)u);
    }

    public void dismissRole(VOMSUser u, VOMSGroup g, VOMSRole r) {
        u.dismissRole(g, r);
        HibernateFactory.getSession().update((Object)u);
    }

    public void deleteAll() {
        Iterator users = this.getAll().iterator();
        while (users.hasNext()) {
            this.delete((VOMSUser)users.next());
        }
    }

    public static VOMSUserDAO instance() {
        HibernateFactory.beginTransaction();
        return new VOMSUserDAO();
    }
}

