/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.database;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.admin.common.VOMSConfiguration;
import org.glite.security.voms.admin.common.VOMSFatalException;
import org.glite.security.voms.admin.database.Auditable;
import org.glite.security.voms.admin.database.HistoryHelper;
import org.glite.security.voms.admin.model.History;
import org.glite.security.voms.admin.model.VOMSAdmin;
import org.hibernate.CallbackException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Session;
import org.hibernate.type.Type;

public class AuditInterceptor
extends EmptyInterceptor {
    private static final long serialVersionUID = 1L;
    static final Log log = LogFactory.getLog(AuditInterceptor.class);
    private Session session;
    private VOMSAdmin admin = null;
    private Map inserts = new HashMap();
    private Set updates = new HashSet();
    private Set deletions = new HashSet();
    private boolean auditUpdates = VOMSConfiguration.instance().getBoolean("voms.auditing.updates", true);
    private boolean auditInserts = VOMSConfiguration.instance().getBoolean("voms.auditing.inserts", true);
    private boolean auditDeletions = VOMSConfiguration.instance().getBoolean("voms.auditing.deletions", true);

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) throws CallbackException {
        if (entity instanceof Auditable) {
            log.debug((Object)("Creating history log record for update operation on: " + entity));
            Object record = HistoryHelper.createUpdateHistoryObject(entity, this.admin, id, propertyNames, previousState);
            this.updates.add(record);
        }
        return false;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        if (entity instanceof Auditable) {
            log.debug((Object)("Creating history log record for insert operation on: " + entity));
            Object record = HistoryHelper.createInsertHistoryObject(this.admin, entity, id, propertyNames, state);
            this.inserts.put(entity, record);
        }
        return false;
    }

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        if (entity instanceof Auditable) {
            log.debug((Object)("Creating history log record for delete operation on: " + entity));
            Object record = HistoryHelper.createDeleteHistoryObject(this.admin, entity, id, propertyNames, state);
            this.deletions.add(record);
        }
    }

    public void postFlush(Iterator entities) throws CallbackException {
        try {
            while (entities.hasNext()) {
                Object entity = entities.next();
                if (!(entity instanceof Auditable) || !this.inserts.containsKey(entity)) continue;
                Object record = (History)this.inserts.get(entity);
                if (((History)record).getWho() == null && entity instanceof VOMSAdmin) {
                    ((History)record).setWho((VOMSAdmin)entity);
                    this.setAdmin((VOMSAdmin)entity);
                }
                HistoryHelper.updateHistoryObjectId(record, (Auditable)entity);
                HistoryHelper.saveHistoryObject(record, this.session.connection());
                this.inserts.remove(entity);
            }
            for (Object record : this.updates) {
                log.debug((Object)("Recording update record: " + record));
                HistoryHelper.saveHistoryObject(record, this.session.connection());
            }
            for (Object record : this.deletions) {
                log.debug((Object)("Recording delete record:" + record));
                HistoryHelper.saveHistoryObject(record, this.session.connection());
            }
        }
        catch (VOMSFatalException e) {
            throw e;
        }
        finally {
            this.inserts.clear();
            this.updates.clear();
            this.deletions.clear();
        }
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public VOMSAdmin getAdmin() {
        return this.admin;
    }

    public void setAdmin(VOMSAdmin admin) {
        this.admin = admin;
    }
}

