/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.database;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.admin.common.VOMSConfiguration;
import org.glite.security.voms.admin.common.VOMSFatalException;
import org.glite.security.voms.admin.database.AuditInterceptor;
import org.glite.security.voms.admin.database.VOMSDatabaseException;
import org.glite.security.voms.admin.model.VOMSAdmin;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;

public class HibernateFactory {
    private static final Log log = LogFactory.getLog(HibernateFactory.class);
    private static final SessionFactory sessionFactory;
    private static final ThreadLocal threadSession;
    private static final ThreadLocal threadTransaction;
    private static final ThreadLocal threadInterceptor;
    private static final boolean auditingEnabled;

    public static SessionFactory getFactory() {
        return sessionFactory;
    }

    public static void setAdmin(VOMSAdmin admin) {
        AuditInterceptor i;
        if (auditingEnabled && (i = (AuditInterceptor)((Object)threadInterceptor.get())) != null) {
            i.setAdmin(admin);
        }
    }

    public static Session getSession() {
        Session s = (Session)threadSession.get();
        try {
            if (s == null) {
                if (auditingEnabled) {
                    AuditInterceptor interceptor = new AuditInterceptor();
                    s = sessionFactory.openSession((Interceptor)interceptor);
                    interceptor.setSession(s);
                    threadInterceptor.set(interceptor);
                } else {
                    s = sessionFactory.openSession();
                }
                threadSession.set(s);
            }
        }
        catch (HibernateException ex) {
            log.fatal((Object)"Error getting hibernate session!", (Throwable)ex);
            throw new VOMSFatalException(ex.getMessage(), ex);
        }
        return s;
    }

    public static void closeSession() {
        try {
            Session s = (Session)threadSession.get();
            threadSession.set(null);
            if (s != null && s.isOpen()) {
                s.close();
            }
        }
        catch (HibernateException ex) {
            log.error((Object)"Error closing hibernate session!", (Throwable)ex);
            throw new VOMSDatabaseException(ex.getMessage(), ex);
        }
    }

    public static void beginTransaction() {
        Transaction tx = (Transaction)threadTransaction.get();
        try {
            if (tx == null) {
                tx = HibernateFactory.getSession().beginTransaction();
                threadTransaction.set(tx);
            }
        }
        catch (HibernateException ex) {
            log.error((Object)"Error creating hibernate transaction!", (Throwable)ex);
            throw new VOMSDatabaseException(ex.getMessage(), ex);
        }
    }

    public static void commitTransaction() {
        Transaction tx = (Transaction)threadTransaction.get();
        try {
            if (tx != null && !tx.wasCommitted() && !tx.wasRolledBack()) {
                tx.commit();
            }
            threadTransaction.set(null);
        }
        catch (HibernateException ex) {
            HibernateFactory.rollbackTransaction();
            log.error((Object)("Error committing hibernate transaction:" + ex.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)"Error committing hibernate transaction!", (Throwable)ex);
            }
            throw new VOMSDatabaseException(ex.getMessage(), ex);
        }
    }

    public static void rollbackTransaction() {
        Transaction tx = (Transaction)threadTransaction.get();
        try {
            threadTransaction.set(null);
            if (tx != null && !tx.wasCommitted() && !tx.wasRolledBack()) {
                tx.rollback();
            }
        }
        catch (HibernateException ex) {
            log.error((Object)("Error rolling back hibernate transaction:" + ex.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)"Error committing hibernate transaction!", (Throwable)ex);
            }
            throw new VOMSDatabaseException(ex.getMessage(), ex);
        }
        finally {
            HibernateFactory.closeSession();
        }
    }

    static {
        threadSession = new ThreadLocal();
        threadTransaction = new ThreadLocal();
        threadInterceptor = new ThreadLocal();
        auditingEnabled = false;
        VOMSConfiguration conf = VOMSConfiguration.instance();
        try {
            Configuration hibernateConf = new Configuration();
            hibernateConf.addProperties(conf.getDatabaseProperties());
            sessionFactory = hibernateConf.configure().buildSessionFactory();
        }
        catch (HibernateException e) {
            log.fatal((Object)"Hibernate session factory creation failed!", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
    }
}

