/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.database;

import java.beans.Expression;
import java.beans.Statement;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.admin.common.VOMSFatalException;
import org.glite.security.voms.admin.database.Auditable;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.glite.security.voms.admin.model.History;
import org.glite.security.voms.admin.model.VOMSAdmin;
import org.hibernate.HibernateException;
import org.hibernate.classic.Session;

public class HistoryHelper {
    public static final short HISTORY_INSERT = 0;
    public static final short HISTORY_UPDATE = 1;
    public static final short HISTORY_DELETE = 2;
    public static final Log log = LogFactory.getLog(HistoryHelper.class);

    private static String buildMethodName(String prefix, String property) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append(property.substring(0, 1).toUpperCase());
        buf.append(property.substring(1));
        return buf.toString();
    }

    public static void populateHistoryObject(Object target, Serializable id, String[] propertyNames, Object[] state) {
        try {
            Statement s = new Statement(target, "setId", new Object[]{id});
            s.execute();
            for (int i = 0; i < propertyNames.length; ++i) {
                s = new Statement(target, HistoryHelper.buildMethodName("set", propertyNames[i]), new Object[]{state[i]});
                s.execute();
            }
        }
        catch (Exception e) {
            log.fatal((Object)e.getMessage(), (Throwable)e);
            throw new VOMSFatalException(e.getMessage(), e);
        }
    }

    public static void updateHistoryObjectId(Object target, Auditable entity) {
        try {
            Expression e = new Expression(entity, "getId", null);
            Object id = e.getValue();
            Statement s = new Statement(target, "setId", new Object[]{id});
            s.execute();
        }
        catch (Exception e) {
            log.fatal((Object)e.getMessage(), (Throwable)e);
            throw new VOMSFatalException(e.getMessage(), e);
        }
    }

    public static void updateHistoryObjectAdmin(Object target, VOMSAdmin admin) {
        History record = (History)target;
        record.setWho(admin);
    }

    private static Object createHistoryObject(short operation, VOMSAdmin admin, Object entity, Serializable id, String[] propertyNames, Object[] state) {
        Object historyObject;
        Date timestamp = Calendar.getInstance().getTime();
        String historyClassName = entity.getClass().getName() + "History";
        Class[] constructorTypes = new Class[]{Short.TYPE, Date.class, VOMSAdmin.class};
        Object[] params = new Object[]{new Short(operation), timestamp, admin};
        try {
            Class<?> historyClass = Class.forName(historyClassName);
            Constructor<?> historyObjectConstructor = historyClass.getConstructor(constructorTypes);
            historyObject = historyObjectConstructor.newInstance(params);
            HistoryHelper.populateHistoryObject(historyObject, id, propertyNames, state);
        }
        catch (Throwable t) {
            log.fatal((Object)t.getMessage(), t);
            throw new VOMSFatalException(t.getMessage(), t);
        }
        return historyObject;
    }

    public static Object createUpdateHistoryObject(Object entity, VOMSAdmin admin, Serializable id, String[] propertyNames, Object[] state) {
        return HistoryHelper.createHistoryObject((short)1, admin, entity, id, propertyNames, state);
    }

    public static Object createInsertHistoryObject(VOMSAdmin admin, Object entity, Serializable id, String[] propertyNames, Object[] state) {
        return HistoryHelper.createHistoryObject((short)0, admin, entity, id, propertyNames, state);
    }

    public static Object createDeleteHistoryObject(VOMSAdmin admin, Object entity, Serializable id, String[] propertyNames, Object[] state) {
        return HistoryHelper.createHistoryObject((short)2, admin, entity, id, propertyNames, state);
    }

    public static void saveHistoryObject(Object record, Connection conn) {
        try {
            Session session = HibernateFactory.getFactory().openSession(conn);
            session.beginTransaction();
            session.save(record);
            session.getTransaction().commit();
        }
        catch (HibernateException e) {
            log.fatal((Object)e.getMessage(), (Throwable)e);
            throw new VOMSFatalException(e.getMessage(), e);
        }
    }
}

