/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.handlers;

import java.sql.BatchUpdateException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.config.ExceptionConfig;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.hibernate.JDBCException;

public class HibernateExceptionHandler
extends ExceptionHandler {
    private static Log log = LogFactory.getLog(HibernateExceptionHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(Exception ex, ExceptionConfig ae, ActionMapping mapping, ActionForm formInstance, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ActionForward forward = null;
        forward = ae.getPath() != null ? new ActionForward(ae.getPath()) : mapping.getInputForward();
        log.info((Object)("Exception caught performing struts action: " + ex.getMessage()));
        log.debug((Object)"Detailed information: ", (Throwable)ex);
        ActionMessage msg = null;
        if (ex instanceof JDBCException) {
            Throwable t = ex.getCause();
            log.info((Object)("Caught JDBCException:" + t.getMessage()));
            msg = new ActionMessage("error.database", (Object)t.getMessage());
            try {
                HibernateFactory.rollbackTransaction();
            }
            finally {
                HibernateFactory.closeSession();
            }
        } else if (ex instanceof BatchUpdateException) {
            Throwable t = ex.getCause();
            log.info((Object)("Caught BatchUpdateException:" + t.getMessage()));
            msg = new ActionMessage("error.database", (Object)t.getMessage());
            try {
                HibernateFactory.rollbackTransaction();
            }
            finally {
                HibernateFactory.closeSession();
            }
        } else {
            log.error((Object)"Caught non JDBCException in HibernateExceptionHandler!", (Throwable)ex);
        }
        if (msg != null) {
            this.storeException(request, msg.getKey(), msg, forward, "request");
        }
        return forward;
    }
}

