/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.jsp;

import java.io.IOException;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.jstl.core.LoopTagSupport;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.admin.operations.VOMSPermission;

public class PrintPermissionTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    public static final String SHORT_HEADER = "short";
    public static final String LONG_HEADER = "long";
    private static final Log log = LogFactory.getLog(PrintPermissionTag.class);
    String header;
    private static final String[] headerNames = new String[]{"Container", "Membership", "ACL", "Attributes", "Requests"};
    private static final String[] shortHeaderNames = new String[]{"Cont.", "Memb.", "ACL", "Attr.", "Req."};

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    private void printLongHeader() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            out.println("<table class='table' cellpadding='0' cellspacing='0'>");
            out.println("<tr class='tableHeaderRow'>");
            for (int i = 0; i < headerNames.length; ++i) {
                out.println("<td>" + headerNames[i] + "</td>");
            }
            out.println("</tr>");
        }
        catch (IOException e) {
            throw new JspTagException(e.getMessage());
        }
    }

    private void printShortHeader() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            out.println("<table class='table' cellpadding='0' cellspacing='0'>");
            out.println("<tr class='tableHeaderRow'>");
            for (int i = 0; i < shortHeaderNames.length; ++i) {
                out.println("<td>" + shortHeaderNames[i] + "</td>");
            }
            out.println("</tr>");
        }
        catch (IOException e) {
            throw new JspTagException(e.getMessage());
        }
    }

    private void printPermissions(VOMSPermission p) throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            out.write("<td>");
            if (p.hasContainerReadPermission()) {
                out.write("r");
            }
            if (p.hasContainerWritePermission()) {
                out.write("w");
            }
            out.write("</td>");
            out.write("<td>");
            if (p.hasMembershipReadPermission()) {
                out.write("r");
            }
            if (p.hasMembershipWritePermission()) {
                out.write("w");
            }
            out.write("</td>");
            out.write("<td>");
            if (p.hasACLReadPermission()) {
                out.write("r");
            }
            if (p.hasACLWritePermission()) {
                out.write("w");
            }
            if (p.hasACLDefaultPermission()) {
                out.write("d");
            }
            out.write("</td>");
            out.write("<td>");
            if (p.hasAttributeReadPermission()) {
                out.write("r");
            }
            if (p.hasAttributeWritePermission()) {
                out.write("w");
            }
            out.write("</td>");
            out.write("<td>");
            if (p.hasRequestReadPermission()) {
                out.write("r");
            }
            if (p.hasRequestWritePermission()) {
                out.write("w");
            }
            out.write("</td>");
        }
        catch (IOException e) {
            throw new JspTagException(e.getMessage());
        }
    }

    private void printFooter() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            out.write("</table>");
        }
        catch (IOException e) {
            throw new JspTagException(e.getMessage());
        }
    }

    public int doStartTag() throws JspException {
        LoopTagSupport ancestorLoop = (LoopTagSupport)PrintPermissionTag.findAncestorWithClass((Tag)this, LoopTagSupport.class);
        Object o = ancestorLoop.getCurrent();
        VOMSPermission p = o instanceof Map.Entry ? (VOMSPermission)((Map.Entry)o).getValue() : (VOMSPermission)o;
        if (this.header == null) {
            this.header = SHORT_HEADER;
        }
        this.printPermissions(p);
        return 0;
    }
}

