/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.jsp;

import java.net.MalformedURLException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.admin.dao.SearchResults;
import org.glite.security.voms.admin.jsp.TagUtils;

public class SearchNavBarTag
extends TagSupport {
    private static final Log log = LogFactory.getLog(SearchNavBarTag.class);
    String id;
    String searchURL;
    String context;
    String permission;
    String styleClass;
    String disabledLinkStyleClass;
    String linkStyleClass;
    private static final long serialVersionUID = 1L;

    protected String buildURL(String text, int firstResult) throws MalformedURLException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        String url = req.getContextPath() + this.searchURL;
        params.put("firstResults", new Integer(firstResult));
        params.put("text", text);
        return org.apache.struts.taglib.TagUtils.getInstance().computeURL(this.pageContext, null, url, null, null, null, params, null, false);
    }

    protected void writeLink(org.apache.struts.taglib.TagUtils t, SearchResults res, int firstResult, String content) throws JspException {
        String url;
        try {
            url = this.buildURL(res.getSearchString(), firstResult);
        }
        catch (MalformedURLException e) {
            throw new JspTagException("Error building searchURL: " + e.getMessage(), (Throwable)e);
        }
        String link = TagUtils.isAuthorized(this.pageContext, this.context, this.permission) ? "<a href=\"" + url + "\" class=\"" + this.linkStyleClass + "\">" + content + "</a>" : "<div class=\"" + this.disabledLinkStyleClass + "\">" + content + "</div>";
        t.write(this.pageContext, link);
    }

    protected void writeFirst(org.apache.struts.taglib.TagUtils t, SearchResults res) throws JspException {
        this.writeLink(t, res, 0, "first");
    }

    protected void writeLast(org.apache.struts.taglib.TagUtils t, SearchResults res) throws JspException {
        this.writeLink(t, res, res.getCount() - res.getResultsPerPage(), "last");
    }

    protected void writePrevious(org.apache.struts.taglib.TagUtils t, SearchResults res) throws JspException {
        int previousIndex = res.getFirstResult() - res.getResultsPerPage();
        if (previousIndex < 0) {
            previousIndex = 0;
        }
        this.writeLink(t, res, previousIndex, "&lt;");
    }

    protected void writeNext(org.apache.struts.taglib.TagUtils t, SearchResults res) throws JspException {
        this.writeLink(t, res, res.getFirstResult() + res.getResultsPerPage(), "&gt;");
    }

    protected void writeResultCount(org.apache.struts.taglib.TagUtils t, SearchResults res) throws JspException {
        String resCount = res.getFirstResult() + 1 + "-" + (res.getFirstResult() + res.getResults().size()) + " of " + res.getCount();
        t.write(this.pageContext, resCount);
    }

    public int doStartTag() throws JspException {
        SearchResults results = (SearchResults)this.pageContext.findAttribute(this.id);
        org.apache.struts.taglib.TagUtils tUtils = org.apache.struts.taglib.TagUtils.getInstance();
        if (results == null) {
            throw new JspTagException("SearchResults not found in pageContext. Key: " + this.id);
        }
        tUtils.write(this.pageContext, "<div class=\"" + this.styleClass + "\">\n");
        if (results.getFirstResult() > 0) {
            if (results.getFirstResult() - results.getResultsPerPage() > 0) {
                this.writeFirst(tUtils, results);
            }
            this.writePrevious(tUtils, results);
        }
        this.writeResultCount(tUtils, results);
        if (results.getRemainingCount() > 0) {
            this.writeNext(tUtils, results);
            if (results.getRemainingCount() > results.getResultsPerPage()) {
                this.writeLast(tUtils, results);
            }
        }
        tUtils.write(this.pageContext, "</div>");
        return 0;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getDisabledLinkStyleClass() {
        return this.disabledLinkStyleClass;
    }

    public void setDisabledLinkStyleClass(String disabledLinkStyleClass) {
        this.disabledLinkStyleClass = disabledLinkStyleClass;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLinkStyleClass() {
        return this.linkStyleClass;
    }

    public void setLinkStyleClass(String linkStyleClass) {
        this.linkStyleClass = linkStyleClass;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public String getSearchURL() {
        return this.searchURL;
    }

    public void setSearchURL(String searchURL) {
        this.searchURL = searchURL;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }
}

