/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.jsp;

import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import org.glite.security.voms.admin.common.VOMSSyntaxException;
import org.glite.security.voms.admin.operations.CurrentAdmin;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;

public class TagUtils {
    public static final String CONTAINER_RW_PERMISSIONS = "rw";
    public static final String CONTAINER_R_PERMISSIONS = "r";
    public static final String CONTAINER_W_PERMISSIONS = "w";

    public static boolean hasPermissions(PageContext pageContext, Map permissionMap) throws JspException {
        if (permissionMap.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : permissionMap.entrySet()) {
            if (TagUtils.isAuthorized(pageContext, (String)entry.getKey(), (String)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean isAuthorized(PageContext pageContext, String vomsContext, String permissions) throws JspException {
        CurrentAdmin admin = CurrentAdmin.instance();
        if (admin == null) {
            throw new JspTagException("No admin defined in the org.glite.security.voms.admin.request context!");
        }
        return admin.hasPermissions(TagUtils.buildContext(vomsContext), TagUtils.buildPermissions(permissions));
    }

    public static VOMSContext buildContext(String context) throws JspException {
        if (context.equals("vo")) {
            return VOMSContext.getVoContext();
        }
        if (context.matches("^vo/.*$")) {
            context = context.replace("vo", VOMSContext.getVoContext().getGroup().getName());
        }
        try {
            return VOMSContext.instance(context);
        }
        catch (VOMSSyntaxException e) {
            throw new JspTagException("VOMS security context creation error (context: " + context + "): " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new JspTagException("VOMS security context creation error (context: " + context + "): " + e.getMessage());
        }
    }

    public static VOMSPermission buildPermissions(String permission) throws JspException {
        try {
            if (permission.equals(CONTAINER_R_PERMISSIONS)) {
                return VOMSPermission.fromString("CONTAINER_READ|MEMBERSHIP_READ");
            }
            if (permission.equals(CONTAINER_W_PERMISSIONS)) {
                return VOMSPermission.fromString("CONTAINER_WRITE|MEMBERSHIP_WRITE");
            }
            if (permission.equals(CONTAINER_RW_PERMISSIONS)) {
                return VOMSPermission.fromString("CONTAINER_READ|CONTAINER_WRITE|MEMBERSHIP_READ|MEMBERSHIP_WRITE");
            }
            return VOMSPermission.fromString(permission);
        }
        catch (IllegalArgumentException e) {
            throw new JspTagException("VOMS permission parse error (permission: " + permission + "): " + e.getMessage());
        }
    }
}

