/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.admin.dao.VOMSAdminDAO;
import org.glite.security.voms.admin.model.VOMSAdmin;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSRole;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;

public class ACL
implements Serializable {
    private static final Log log = LogFactory.getLog(ACL.class);
    Long id;
    VOMSGroup group = null;
    Boolean defaultACL;
    VOMSRole role = null;
    Map permissions = new HashMap();

    public ACL() {
    }

    public ACL(VOMSGroup g, VOMSRole r, boolean isDefaultACL) {
        this.group = g;
        this.role = r;
        this.defaultACL = new Boolean(isDefaultACL);
    }

    public ACL(VOMSGroup g, boolean isDefaultACL) {
        this(g, null, isDefaultACL);
    }

    public VOMSGroup getGroup() {
        return this.group;
    }

    public void setGroup(VOMSGroup group) {
        this.group = group;
    }

    public Map getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Map permissions) {
        this.permissions = permissions;
    }

    public VOMSRole getRole() {
        return this.role;
    }

    public void setRole(VOMSRole role) {
        this.role = role;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ACL)) {
            return false;
        }
        ACL that = (ACL)other;
        if (that == null) {
            return false;
        }
        if (this.getGroup().equals(that.getGroup())) {
            if (this.getRole() == null && that.getRole() == null) {
                return this.getDefaultACL().equals(that.getDefaultACL());
            }
            if (this.getRole() != null && that.getRole() != null) {
                return this.getRole().equals(that.getRole());
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 14;
        result = 29 * result + this.getGroup().hashCode();
        if (this.getRole() != null) {
            result = 29 * result + this.getRole().hashCode();
        }
        return result;
    }

    public Boolean getDefaultACL() {
        return this.defaultACL;
    }

    public void setDefaultACL(Boolean defaultACL) {
        this.defaultACL = defaultACL;
    }

    public Long getId() {
        return this.id;
    }

    public void setPermissions(VOMSAdmin a, VOMSPermission p) {
        this.getPermissions().put(a, p);
    }

    public void removePermissions(VOMSAdmin a) {
        this.getPermissions().remove(a);
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean isDefautlACL() {
        return this.defaultACL;
    }

    public VOMSPermission getPermissions(VOMSAdmin a) {
        return (VOMSPermission)this.getPermissions().get(a);
    }

    public Map getRolePermissions() {
        HashMap result = new HashMap();
        for (Map.Entry entry : this.permissions.entrySet()) {
            VOMSAdmin admin = (VOMSAdmin)entry.getKey();
            if (!admin.getCa().getDn().equals("/O=VOMS/O=System/CN=VOMS Role")) continue;
            result.put(admin, entry.getValue());
        }
        return result;
    }

    public Map getGroupPermissions() {
        HashMap result = new HashMap();
        for (Map.Entry entry : this.permissions.entrySet()) {
            VOMSAdmin admin = (VOMSAdmin)entry.getKey();
            if (!admin.getCa().getDn().equals("/O=VOMS/O=System/CN=VOMS Group")) continue;
            result.put(admin, entry.getValue());
        }
        return result;
    }

    public Set getAdminsWithPermissions(VOMSPermission requiredPermission) {
        HashSet results = new HashSet();
        for (Map.Entry entry : this.permissions.entrySet()) {
            VOMSPermission p = (VOMSPermission)entry.getValue();
            VOMSAdmin a = (VOMSAdmin)entry.getKey();
            if (!p.satisfies(requiredPermission) || !a.isGroupAdmin() && !a.isRoleAdmin()) continue;
            results.add(entry.getKey());
        }
        return results;
    }

    public VOMSPermission getAnyAuthenticatedUserPermissions() {
        VOMSAdmin anyAuthenticatedUserAdmin = VOMSAdminDAO.instance().getAnyAuthenticatedUserAdmin();
        return (VOMSPermission)this.permissions.get(anyAuthenticatedUserAdmin);
    }

    public Map getExternalPermissions() {
        HashMap result = new HashMap();
        for (VOMSAdmin admin : this.permissions.keySet()) {
            if (!admin.getDn().equals("/O=VOMS/O=System/CN=Any Authenticated User") && admin.getDn().startsWith("/O=VOMS/O=System")) continue;
            result.put(admin, this.permissions.get(admin));
        }
        return result;
    }

    public VOMSContext getContext() {
        return VOMSContext.instance(this.getGroup(), this.getRole());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

