/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.model;

import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.admin.common.PathNamingScheme;
import org.glite.security.voms.admin.common.VOMSSyntaxException;
import org.glite.security.voms.admin.database.Auditable;
import org.glite.security.voms.admin.model.VOMSCA;

public class VOMSAdmin
implements Serializable,
Auditable,
Cloneable {
    private static Log log = LogFactory.getLog(VOMSAdmin.class);
    private static final long serialVersionUID = -5459874418491929253L;
    Long id;
    String dn;
    VOMSCA ca;
    String emailAddress;

    public VOMSCA getCa() {
        return this.ca;
    }

    public void setCa(VOMSCA ca) {
        this.ca = ca;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VOMSAdmin)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        VOMSAdmin that = (VOMSAdmin)other;
        return this.getDn().equals(that.getDn());
    }

    public int hashCode() {
        return this.getDn().hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        VOMSAdmin newInstance = (VOMSAdmin)super.clone();
        newInstance.id = this.id;
        newInstance.dn = this.dn;
        newInstance.ca = this.ca;
        return newInstance;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        return builder.append((Object)this.dn).append((Object)this.ca.getDn()).toString();
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public boolean isInternalAdmin() {
        return this.getCa().getDn().startsWith("/O=VOMS/O=System");
    }

    public boolean isGroupAdmin() {
        boolean result;
        try {
            result = PathNamingScheme.isGroup(this.getDn());
        }
        catch (VOMSSyntaxException e) {
            return false;
        }
        return result;
    }

    public boolean isRoleAdmin() {
        boolean result;
        try {
            result = PathNamingScheme.isQualifiedRole(this.getDn());
        }
        catch (VOMSSyntaxException e) {
            return false;
        }
        return result;
    }

    public String getEscapedDn() {
        return this.dn.replaceAll("'", "\\\\'");
    }
}

