/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.glite.security.voms.admin.database.Auditable;
import org.glite.security.voms.admin.database.NoSuchAttributeException;
import org.glite.security.voms.admin.model.ACL;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSMapping;
import org.glite.security.voms.admin.model.VOMSRoleAttribute;
import org.glite.security.voms.admin.model.VOMSUser;

public class VOMSRole
implements Serializable,
Auditable,
Comparable {
    private static final long serialVersionUID = -5063337678658382573L;
    Long id;
    String name;
    Set attributes = new HashSet();
    Set mappings = new TreeSet();
    Set acls = new HashSet();

    public VOMSRole() {
    }

    public VOMSRole(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VOMSRole)) {
            return false;
        }
        VOMSRole that = (VOMSRole)other;
        if (that == null) {
            return false;
        }
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        VOMSRole that = (VOMSRole)o;
        if (that.name == null && this.name == null) {
            return 1;
        }
        if (that.name == null || this.name == null) {
            return -1;
        }
        return this.name.compareTo(that.name);
    }

    public String toString() {
        return "Role=" + this.name;
    }

    public Set getMappings() {
        return this.mappings;
    }

    public void setMappings(Set mappings) {
        this.mappings = mappings;
    }

    public Set getUsers(VOMSGroup g) {
        TreeSet<VOMSUser> res = new TreeSet<VOMSUser>();
        for (VOMSMapping m : this.mappings) {
            if (!m.getGroup().equals(g)) continue;
            res.add(m.getUser());
        }
        return Collections.unmodifiableSortedSet(res);
    }

    public Set getMembersEmailAddresses(VOMSGroup g) {
        TreeSet<String> res = new TreeSet<String>();
        for (VOMSMapping m : this.mappings) {
            if (!m.getGroup().equals(g)) continue;
            res.add(m.getUser().getEmailAddress());
        }
        return Collections.unmodifiableSortedSet(res);
    }

    public boolean isAssignedTo(VOMSGroup g, VOMSUser u) {
        if (g == null) {
            throw new IllegalArgumentException("g must not be null!");
        }
        if (u == null) {
            throw new IllegalArgumentException("u must not be null!");
        }
        VOMSMapping m = new VOMSMapping(u, g, this);
        return this.mappings.contains(m);
    }

    public VOMSRoleAttribute getAttributeByName(VOMSGroup g, String attrName) {
        for (VOMSRoleAttribute rav : this.attributes) {
            if (!rav.getGroup().equals(g) || !rav.getName().equals(attrName)) continue;
            return rav;
        }
        return null;
    }

    public Set getAttributesInGroup(VOMSGroup g) {
        HashSet<VOMSRoleAttribute> result = new HashSet<VOMSRoleAttribute>();
        for (VOMSRoleAttribute rav : this.attributes) {
            if (!rav.getGroup().equals(g)) continue;
            result.add(rav);
        }
        return result;
    }

    public void removeAttributesInGroup(VOMSGroup g) {
        for (VOMSRoleAttribute rav : this.attributes) {
            if (!rav.getGroup().equals(g)) continue;
            this.deleteAttribute(rav);
        }
    }

    public void addAttribute(VOMSRoleAttribute val) {
        this.attributes.add(val);
    }

    public void deleteAttribute(VOMSRoleAttribute val) {
        if (!this.attributes.contains(val)) {
            throw new NoSuchAttributeException("Attribute \"" + val.getName() + "\" not defined for \"" + this + "\" in group \"" + val.getGroup() + "\".");
        }
        this.attributes.remove(val);
    }

    public Set getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Set attributes) {
        this.attributes = attributes;
    }

    public Set getAcls() {
        return this.acls;
    }

    public void setAcls(Set acls) {
        this.acls = acls;
    }

    public ACL getACL(VOMSGroup g) {
        ACL result = null;
        for (ACL tmp : this.getAcls()) {
            if (!tmp.getGroup().equals(g) || tmp.getContext().isGroupContext()) continue;
            result = tmp;
            break;
        }
        return result;
    }

    public void importACL(VOMSGroup g) {
        ACL groupACL = g.getDefaultACL() == null ? g.getACL() : g.getDefaultACL();
        ACL newACL = new ACL(g, this, false);
        newACL.getPermissions().putAll(groupACL.getPermissions());
        this.getAcls().add(newACL);
    }
}

