/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.User;
import org.glite.security.voms.admin.actionforms.UserForm;
import org.glite.security.voms.admin.common.NullArgumentException;
import org.glite.security.voms.admin.common.PathNamingScheme;
import org.glite.security.voms.admin.common.VOMSSyntaxException;
import org.glite.security.voms.admin.database.AlreadyExistsException;
import org.glite.security.voms.admin.database.Auditable;
import org.glite.security.voms.admin.database.NoSuchAttributeException;
import org.glite.security.voms.admin.database.NoSuchMappingException;
import org.glite.security.voms.admin.database.VOMSInconsistentDatabaseException;
import org.glite.security.voms.admin.model.VOMSCA;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSMapping;
import org.glite.security.voms.admin.model.VOMSRole;
import org.glite.security.voms.admin.model.VOMSUserAttribute;

public class VOMSUser
implements Serializable,
Auditable,
Comparable {
    private static final long serialVersionUID = -3815869585264835046L;
    public static final Log log = LogFactory.getLog(VOMSUser.class);
    Long id;
    String dn;
    VOMSCA ca;
    String cn;
    String emailAddress;
    String certURI;
    Set attributes = new HashSet();
    Set mappings = new TreeSet();

    public String getDn() {
        return this.dn;
    }

    public void setDn(String name) {
        this.dn = name;
    }

    public String getCn() {
        return this.cn;
    }

    public void setCn(String cn) {
        this.cn = cn;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public VOMSCA getCa() {
        return this.ca;
    }

    public void setCa(VOMSCA ca) {
        this.ca = ca;
    }

    public String getCertURI() {
        return this.certURI;
    }

    public void setCertURI(String certURI) {
        this.certURI = certURI;
    }

    public Set getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Set attributes) {
        this.attributes = attributes;
    }

    public Set getMappings() {
        return this.mappings;
    }

    public void setMappings(Set mappings) {
        this.mappings = mappings;
    }

    public VOMSUserAttribute getAttributeByName(String name) {
        for (VOMSUserAttribute tmp : this.attributes) {
            if (!tmp.getName().equals(name)) continue;
            return tmp;
        }
        return null;
    }

    public void deleteAttributeByName(String attrName) {
        this.deleteAttribute(this.getAttributeByName(attrName));
    }

    public void deleteAttribute(VOMSUserAttribute val) {
        if (!this.attributes.contains(val)) {
            throw new NoSuchAttributeException("Attribute \"" + val.getName() + "\" undefined for user " + this);
        }
        this.attributes.remove(val);
    }

    public void setAttribute(String name, String value) {
        VOMSUserAttribute val = this.getAttributeByName(name);
        if (val == null) {
            throw new NoSuchAttributeException("Attribute \"" + name + "\" undefined for user \"" + this.dn + "\".");
        }
        val.setValue(value);
    }

    public void addAttribute(VOMSUserAttribute val) {
        val.setUser(this);
        if (this.attributes.contains(val)) {
            this.attributes.remove(val);
        }
        this.attributes.add(val);
    }

    public boolean isMember(String groupName) {
        if (groupName == null) {
            throw new NullArgumentException("Cannot org.glite.security.voms.admin.test membership in a null group!");
        }
        if (!PathNamingScheme.isGroup(groupName)) {
            throw new VOMSSyntaxException("Group name passed as argument does not respect the VOMS FQAN syntax. [" + groupName + "]");
        }
        for (VOMSMapping m : this.getMappings()) {
            if (!m.getGroup().getName().equals(groupName) || !m.isGroupMapping()) continue;
            return true;
        }
        return false;
    }

    public boolean isMember(VOMSGroup g) {
        if (g == null) {
            throw new NullArgumentException("Cannot org.glite.security.voms.admin.test membership in a null group!");
        }
        for (VOMSMapping m : this.getMappings()) {
            if (!m.getGroup().equals(g) || !m.isGroupMapping()) continue;
            return true;
        }
        return false;
    }

    public void addToGroup(VOMSGroup g) {
        log.debug((Object)("Adding user \"" + this + "\" to group \"" + g + "\"."));
        VOMSMapping m = new VOMSMapping(this, g, null);
        if (!this.getMappings().add(m)) {
            throw new AlreadyExistsException("User \"" + this + "\" is already a member of group \"" + g + "\".");
        }
        if (!g.isRootGroup() && !this.isMember(g.parent)) {
            this.addToGroup(g.parent);
        }
    }

    public void removeFromGroup(VOMSGroup g) {
        log.debug((Object)("Removing user \"" + this + "\" from group \"" + g + "\"."));
        this.dismissRolesInGroup(g);
        VOMSMapping m = new VOMSMapping(this, g, null);
        if (!this.getMappings().contains(m)) {
            throw new NoSuchMappingException("User \"" + this + "\" is not a member of group \"" + g + "\".");
        }
        this.getMappings().remove(m);
    }

    public VOMSMapping assignRole(VOMSGroup g, VOMSRole r) {
        if (!this.isMember(g)) {
            throw new NoSuchMappingException("User \"" + this + "\" is not a member of group \"" + g + "\".");
        }
        VOMSMapping m = new VOMSMapping(this, g, r);
        if (this.getMappings().contains(m)) {
            throw new AlreadyExistsException("User \"" + this + "\" already has role \"" + r + "\" in group \"" + g + "\".");
        }
        log.debug((Object)("Assigning role \"" + r + "\" to user \"" + this + "\" in group \"" + g + "\"."));
        this.getMappings().add(m);
        r.getMappings().add(m);
        return m;
    }

    public VOMSMapping dismissRole(VOMSGroup g, VOMSRole r) {
        if (!this.isMember(g)) {
            throw new NoSuchMappingException("User \"" + this + "\" is not a member of group \"" + g + "\".");
        }
        if (!this.hasRole(g, r)) {
            throw new NoSuchMappingException("User \"" + this + "\" does not have role \"" + r + "\" in group \"" + g + "\".");
        }
        log.debug((Object)("Dismissing role \"" + r + "\" from user \"" + this + "\" in group \"" + g + "\"."));
        Iterator i = this.getMappings().iterator();
        boolean removed = false;
        VOMSMapping m = null;
        while (i.hasNext()) {
            m = (VOMSMapping)i.next();
            if (!m.isRoleMapping() || !m.getGroup().equals(g) || !m.getRole().equals(r)) continue;
            i.remove();
            r.getMappings().remove(m);
            removed = true;
        }
        if (!removed) {
            throw new VOMSInconsistentDatabaseException("Error removing exiting role mapping!");
        }
        return m;
    }

    public void dismissRolesInGroup(VOMSGroup g) {
        if (!this.isMember(g)) {
            throw new NoSuchMappingException("User \"" + this + "\" is not a member of group \"" + g + "\".");
        }
        Iterator i = this.getMappings().iterator();
        while (i.hasNext()) {
            VOMSMapping m = (VOMSMapping)i.next();
            if (!m.getGroup().equals(g) || !m.isRoleMapping()) continue;
            i.remove();
        }
    }

    public boolean hasRole(VOMSGroup g, VOMSRole r) {
        if (!this.isMember(g)) {
            throw new NoSuchMappingException("User \"" + this + "\" is not a member of group \"" + g + "\".");
        }
        for (VOMSMapping m : this.getMappings()) {
            if (!m.isRoleMapping() || !m.getGroup().equals(g) || !m.getRole().equals(r)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRole(String fqan) {
        if (!PathNamingScheme.isQualifiedRole(fqan)) {
            throw new IllegalArgumentException("Role name passed as argument is not a qualified role! [" + fqan + "]");
        }
        String groupName = PathNamingScheme.getGroupName(fqan);
        String roleName = PathNamingScheme.getRoleName(fqan);
        for (VOMSMapping m : this.getMappings()) {
            if (!m.isRoleMapping() || !m.getGroup().getName().equals(groupName) || !m.getRole().getName().equals(roleName)) continue;
            return true;
        }
        return false;
    }

    public Set getGroups() {
        TreeSet<VOMSGroup> res = new TreeSet<VOMSGroup>();
        for (VOMSMapping m : this.getMappings()) {
            if (!m.isGroupMapping()) continue;
            res.add(m.getGroup());
        }
        return Collections.unmodifiableSortedSet(res);
    }

    public Set getRoles(VOMSGroup g) {
        TreeSet<VOMSRole> res = new TreeSet<VOMSRole>();
        for (VOMSMapping m : this.getMappings()) {
            if (!m.isRoleMapping() || !m.getGroup().equals(g)) continue;
            res.add(m.getRole());
        }
        return Collections.unmodifiableSortedSet(res);
    }

    public Set getRoleMappings() {
        TreeSet<String> res = new TreeSet<String>();
        for (VOMSMapping m : this.getMappings()) {
            if (!m.isRoleMapping()) continue;
            res.add(m.getFQAN());
        }
        return res;
    }

    public Map getMappingsMap() {
        log.debug((Object)("mappings.size(): " + this.getMappings().size()));
        if (this.getMappings().size() == 0) {
            return null;
        }
        Iterator i = this.getMappings().iterator();
        TreeMap map = new TreeMap();
        while (i.hasNext()) {
            Set<VOMSRole> s;
            VOMSMapping m = (VOMSMapping)i.next();
            log.debug((Object)("mapping: " + m));
            if (m.isGroupMapping()) {
                log.debug((Object)("Added group mapping to map: " + m.getGroup()));
                map.put(m.getGroup(), new TreeSet());
                continue;
            }
            if (!m.isRoleMapping()) continue;
            if (!map.containsKey(m.getGroup())) {
                s = new TreeSet<VOMSRole>();
                s.add(m.getRole());
                map.put(m.getGroup(), s);
                log.debug((Object)("Added mapping to map: " + m));
                continue;
            }
            s = (Set)map.get(m.getGroup());
            s.add(m.getRole());
            map.put(m.getGroup(), s);
            log.debug((Object)("Added mapping to map:" + m.getRole()));
        }
        return map;
    }

    public VOMSUser populate(UserForm form) {
        this.setDn(form.getDn());
        this.setCn(form.getCn());
        this.setEmailAddress(form.getEmailAddress());
        return this;
    }

    public void fromUser(User u) {
        if (u == null) {
            throw new NullArgumentException("User passed as argument is null!");
        }
        this.setCn(u.getCN());
        this.setEmailAddress(u.getMail());
    }

    public User asUser() {
        User u = new User();
        u.setDN(this.getDn());
        u.setCA(this.getCa().getDn());
        u.setCN(this.getCn());
        u.setMail(this.getEmailAddress());
        u.setCertUri(this.getCertURI());
        return u;
    }

    public static User[] collectionAsUsers(Collection c) {
        if (c == null || c.isEmpty()) {
            return null;
        }
        User[] users = new User[c.size()];
        int index = 0;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            users[index++] = ((VOMSUser)i.next()).asUser();
        }
        return users;
    }

    public String toString() {
        return "(" + this.dn + "," + this.ca + ")";
    }

    public boolean equals(Object other) {
        log.debug((Object)("Comparing users for equality, this:" + this + ", other:" + other));
        if (this == other) {
            log.debug((Object)"Same object, will return true");
            return true;
        }
        if (!(other instanceof VOMSUser)) {
            log.debug((Object)"The other is not a VOMSUser, returning false");
            return false;
        }
        VOMSUser that = (VOMSUser)other;
        if (that == null) {
            log.debug((Object)"The other is null, returning false!");
            return false;
        }
        if (this.getDn().equals(that.getDn())) {
            log.debug((Object)"Same DN, check on the CAs");
            boolean result = this.getCa().equals(that.getCa());
            log.debug((Object)("Will return: " + result));
            return result;
        }
        log.debug((Object)"Different DNs, will return false.");
        return false;
    }

    public int hashCode() {
        int result = 14;
        result = 29 * result + this.getDn().hashCode();
        if (this.ca != null) {
            result = 29 * result + this.getCa().hashCode();
        }
        return result;
    }

    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        VOMSUser that = (VOMSUser)o;
        if (that == null) {
            return 1;
        }
        if (this.getDn().equals(that.getDn())) {
            return this.getCa().getDn().compareTo(that.getCa().getDn());
        }
        return this.getDn().compareTo(that.getDn());
    }

    public String getShortName() {
        return this.dn;
    }

    public String getEscapedDn() {
        return this.dn.replaceAll("'", "\\\\'");
    }
}

