/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.notification;

import java.util.HashSet;
import java.util.Set;
import org.glite.security.voms.admin.common.PathNamingScheme;
import org.glite.security.voms.admin.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.model.VOMSAdmin;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSRole;

public class NotificationUtil {
    public static Set getEmailAddressesForAdmin(VOMSAdmin a) {
        HashSet<String> emails = new HashSet<String>();
        if (!a.isInternalAdmin()) {
            emails.add(a.getEmailAddress());
        } else if (a.isGroupAdmin()) {
            VOMSGroup g = VOMSGroupDAO.instance().findByName(a.getDn());
            emails.addAll(g.getMembersEmailAddresses());
        } else if (a.isRoleAdmin()) {
            VOMSRole r = VOMSRoleDAO.instance().findByName(PathNamingScheme.getRoleName(a.getDn()));
            VOMSGroup g = VOMSGroupDAO.instance().findByName(PathNamingScheme.getGroupName(a.getDn()));
            emails.addAll(r.getMembersEmailAddresses(g));
        }
        return emails;
    }
}

