/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.builder.StandardToStringStyle;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.admin.common.NullArgumentException;
import org.glite.security.voms.admin.common.VOMSAuthorizationException;
import org.glite.security.voms.admin.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.database.VOMSInconsistentDatabaseException;
import org.glite.security.voms.admin.model.ACL;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.operations.CurrentAdmin;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSOperation;
import org.glite.security.voms.admin.operations.VOMSPermission;

public abstract class BaseVomsOperation
implements VOMSOperation {
    protected Map __requiredPermissions = new HashMap();
    private static final Log __log;

    private boolean permissionsInitialized() {
        return this.__requiredPermissions != null && !this.__requiredPermissions.isEmpty();
    }

    protected final void addRequiredPermission(VOMSContext ctxt, VOMSPermission p) {
        if (ctxt == null) {
            throw new NullArgumentException("Cannot add a null context to required permissions");
        }
        if (p == null) {
            throw new NullArgumentException("Cannot set a null permission for a context.");
        }
        this.__requiredPermissions.put(ctxt, p);
    }

    protected final void addRequiredPermissionOnAllGroups(VOMSPermission p) {
        Iterator allGroups = VOMSGroupDAO.instance().findAll().iterator();
        while (allGroups.hasNext()) {
            this.addRequiredPermission(VOMSContext.instance((VOMSGroup)allGroups.next()), p);
        }
    }

    protected final void addRequiredPermissionOnPath(VOMSGroup leafGroup, VOMSPermission p) {
        if (leafGroup == null) {
            throw new NullArgumentException("Cannot add a null context to required permissions");
        }
        if (p == null) {
            throw new NullArgumentException("Cannot set a null permission for a context.");
        }
        this.addRequiredPermission(VOMSContext.instance(leafGroup), p);
        VOMSGroup parent = leafGroup.getParent();
        do {
            this.addRequiredPermission(VOMSContext.instance(parent), p);
        } while (!(parent = parent.getParent()).isRootGroup());
    }

    protected BaseVomsOperation() {
    }

    public final boolean isAllowed() {
        CurrentAdmin admin = CurrentAdmin.instance();
        if (!this.permissionsInitialized()) {
            this.setupPermissions();
        }
        if (this.__requiredPermissions.isEmpty()) {
            throw new VOMSAuthorizationException("Required permissions not defined for " + this.getName() + " operation!");
        }
        for (VOMSContext ctxt : this.__requiredPermissions.keySet()) {
            VOMSPermission requiredPerms = (VOMSPermission)this.__requiredPermissions.get(ctxt);
            ACL acl = ctxt.getACL();
            if (acl == null) {
                throw new VOMSInconsistentDatabaseException("ACL not found for context \"" + ctxt + "\".");
            }
            if (admin.hasPermissions(ctxt, requiredPerms)) continue;
            return false;
        }
        return true;
    }

    public final Object execute() {
        this.logOperation();
        if (!this.isAllowed()) {
            throw new VOMSAuthorizationException(CurrentAdmin.instance().getAdmin(), this, "Insufficient privileges");
        }
        return this.doExecute();
    }

    protected abstract void setupPermissions();

    protected abstract Object doExecute();

    protected final void addPermissionsOnPath(VOMSGroup g, VOMSPermission p) {
        VOMSGroup parentGroup = g.getParent();
        do {
            __log.debug((Object)("Adding required permission " + p + " for group: " + parentGroup));
            this.addRequiredPermission(VOMSContext.instance(parentGroup), p);
        } while (!(parentGroup = parentGroup.getParent()).isRootGroup());
        this.addRequiredPermission(VOMSContext.instance(parentGroup), p);
    }

    protected final void logRequiredPermissions() {
        __log.debug((Object)("[" + this.getClass() + "] requiredPerms: " + ToStringBuilder.reflectionToString((Object)this.__requiredPermissions) + ""));
    }

    protected final String logOperationMessage() {
        StringBuffer logStr = new StringBuffer();
        String opName = this.getName();
        logStr.append(opName + "(");
        logStr.append(this.logArgs());
        logStr.append(")");
        return logStr.toString();
    }

    protected String logArgs() {
        String message = ToStringBuilder.reflectionToString((Object)this);
        message = message.replaceAll(",?__\\p{Alpha}*=[^,\\]]*,?", "");
        return message;
    }

    protected final void logOperation() {
        String adminSubj = CurrentAdmin.instance().getRealSubject();
        String adminIssuer = CurrentAdmin.instance().getRealIssuer();
        String message = "Operation: " + this.logOperationMessage() + " - (" + adminSubj + "," + adminIssuer + ")";
        __log.info((Object)message);
    }

    public String getName() {
        String clazzName = this.getClass().getName();
        return clazzName.substring(clazzName.lastIndexOf(46) + 1);
    }

    public final Map getRequiredPermissions() {
        if (!this.permissionsInitialized()) {
            this.setupPermissions();
        }
        return this.__requiredPermissions;
    }

    static {
        StandardToStringStyle stss = new StandardToStringStyle();
        stss.setUseClassName(false);
        stss.setUseIdentityHashCode(false);
        ToStringBuilder.setDefaultStyle((ToStringStyle)stss);
        __log = LogFactory.getLog(BaseVomsOperation.class);
    }
}

