/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.SecurityContext;
import org.glite.security.voms.admin.common.DNUtil;
import org.glite.security.voms.admin.dao.VOMSAdminDAO;
import org.glite.security.voms.admin.dao.VOMSUserDAO;
import org.glite.security.voms.admin.model.ACL;
import org.glite.security.voms.admin.model.VOMSAdmin;
import org.glite.security.voms.admin.model.VOMSCA;
import org.glite.security.voms.admin.model.VOMSUser;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.operations.VOMSPermissionList;

public class CurrentAdmin {
    private static final Log log = LogFactory.getLog(CurrentAdmin.class);
    private VOMSAdmin admin;

    public VOMSAdmin getAdmin() {
        return this.admin;
    }

    protected CurrentAdmin(VOMSAdmin a) {
        this.admin = a;
    }

    public static CurrentAdmin instance() {
        SecurityContext theContext = SecurityContext.getCurrentContext();
        String adminDN = theContext.getClientName();
        String caDN = theContext.getIssuerName();
        VOMSAdmin admin = VOMSAdminDAO.instance().getByName(adminDN, caDN);
        if (admin == null) {
            admin = VOMSAdminDAO.instance().getAnyAuthenticatedUserAdmin();
        }
        return new CurrentAdmin(admin);
    }

    public VOMSCA getCa() {
        return this.admin.getCa();
    }

    public String getDn() {
        return this.admin.getDn();
    }

    public boolean isAuthorizedAdmin() {
        return !this.getAdmin().equals(VOMSAdminDAO.instance().getAnyAuthenticatedUserAdmin());
    }

    public boolean isVoUser() {
        return this.getVoUser() != null;
    }

    public VOMSUser getVoUser() {
        if (!this.isAuthorizedAdmin()) {
            return VOMSUserDAO.instance().getByName(this.getRealSubject(), this.getRealIssuer());
        }
        return VOMSUserDAO.instance().getByName(this.admin.getDn(), this.admin.getCa());
    }

    public void createVoUser() {
        VOMSUser usr = this.getVoUser();
        if (usr == null) {
            VOMSUserDAO.instance().create(this.getRealSubject(), this.getRealIssuer(), this.getRealCN(), null, this.getRealEmailAddress());
        }
    }

    public boolean hasPermissions(VOMSContext c, VOMSPermission p) {
        ACL acl = c.getACL();
        log.debug((Object)("Checking if admin " + this.getAdmin() + " has permission " + p + " in context " + c));
        log.debug((Object)"ACL for this context: ");
        log.debug((Object)acl);
        VOMSUser adminUser = this.getVoUser();
        log.debug((Object)("Admin user: " + adminUser));
        VOMSPermission personalPermissions = acl.getPermissions(this.admin);
        log.debug((Object)("Permissions for admin: " + personalPermissions));
        VOMSPermission anyAuthenticatedUserPermissions = acl.getAnyAuthenticatedUserPermissions();
        log.debug((Object)("Permissions for any authenticated user: " + anyAuthenticatedUserPermissions));
        VOMSPermissionList adminPerms = VOMSPermissionList.instance();
        if (personalPermissions == null && adminUser == null && anyAuthenticatedUserPermissions == null) {
            return false;
        }
        if (personalPermissions != null) {
            adminPerms.addPermission(personalPermissions);
        }
        if (anyAuthenticatedUserPermissions != null) {
            adminPerms.addPermission(anyAuthenticatedUserPermissions);
        }
        if (adminUser == null) {
            return adminPerms.satifies(p);
        }
        Map groupPermissions = acl.getGroupPermissions();
        Map rolePermissions = acl.getRolePermissions();
        log.debug((Object)("Group permissions empty? " + groupPermissions.isEmpty()));
        log.debug((Object)("Role permissions empty? " + rolePermissions.isEmpty()));
        if (!groupPermissions.isEmpty()) {
            for (Map.Entry entry : groupPermissions.entrySet()) {
                String groupName = ((VOMSAdmin)entry.getKey()).getDn();
                if (!adminUser.isMember(groupName)) continue;
                adminPerms.addPermission((VOMSPermission)entry.getValue());
                log.debug((Object)("Adding group permission " + entry.getValue() + " to admin's permission set. admin is a member of the group '" + groupName + "'."));
            }
        }
        if (!rolePermissions.isEmpty()) {
            for (Map.Entry entry : rolePermissions.entrySet()) {
                String roleName = ((VOMSAdmin)entry.getKey()).getDn();
                log.debug((Object)("Checking if current admin has role: " + roleName));
                if (!adminUser.hasRole(roleName)) continue;
                adminPerms.addPermission((VOMSPermission)entry.getValue());
                log.debug((Object)("Adding role permission " + entry.getValue() + " to admin's permission set. admin has role '" + roleName + "'."));
            }
        }
        log.debug((Object)("Admin permissions: " + adminPerms));
        return adminPerms.satifies(p);
    }

    public String getRealSubject() {
        SecurityContext theContext = SecurityContext.getCurrentContext();
        return theContext.getClientName();
    }

    public String getRealIssuer() {
        SecurityContext theContext = SecurityContext.getCurrentContext();
        return theContext.getIssuerName();
    }

    public String getRealCN() {
        SecurityContext theContext = SecurityContext.getCurrentContext();
        String name = DNUtil.getBCasX500(theContext.getClientCert().getSubjectX500Principal());
        Matcher m = Pattern.compile("/CN=([^/]*)").matcher(name);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public String getRealEmailAddress() {
        SecurityContext theContext = SecurityContext.getCurrentContext();
        String name = DNUtil.getBCasX500(theContext.getClientCert().getSubjectX500Principal());
        return DNUtil.getEmailAddressFromDN(DNUtil.normalizeEmailAddressInDN(name));
    }

    public String toString() {
        return this.admin.toString();
    }
}

