/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations;

import org.glite.security.voms.admin.common.PathNamingScheme;
import org.glite.security.voms.admin.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.database.NoSuchGroupException;
import org.glite.security.voms.admin.database.NoSuchRoleException;
import org.glite.security.voms.admin.model.ACL;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSRole;

public class VOMSContext {
    VOMSGroup group;
    VOMSRole role;

    protected VOMSContext(VOMSGroup g, VOMSRole r) {
        this.group = g;
        this.role = r;
    }

    public VOMSGroup getGroup() {
        return this.group;
    }

    public void setGroup(VOMSGroup group) {
        this.group = group;
    }

    public VOMSRole getRole() {
        return this.role;
    }

    public void setRole(VOMSRole role) {
        this.role = role;
    }

    public static VOMSContext instance(VOMSGroup g) {
        return VOMSContext.instance(g, null);
    }

    public static VOMSContext instance(VOMSGroup g, VOMSRole r) {
        if (g == null) {
            throw new IllegalArgumentException("null group passed as argument to constructor!");
        }
        return new VOMSContext(g, r);
    }

    public static VOMSContext instance(String contextString) {
        if (contextString == null) {
            throw new IllegalArgumentException("null is not a valid VOMS context!");
        }
        if (PathNamingScheme.isGroup(contextString)) {
            VOMSGroup g = VOMSGroupDAO.instance().findByName(contextString);
            if (g == null) {
                throw new NoSuchGroupException("Group '" + PathNamingScheme.getGroupName(contextString) + "' is not defined for this vo.");
            }
            return new VOMSContext(g, null);
        }
        if (PathNamingScheme.isQualifiedRole(contextString)) {
            VOMSGroup g = VOMSGroupDAO.instance().findByName(PathNamingScheme.getGroupName(contextString));
            VOMSRole r = VOMSRoleDAO.instance().findByName(PathNamingScheme.getRoleName(contextString));
            if (g == null) {
                throw new NoSuchGroupException("Group '" + PathNamingScheme.getGroupName(contextString) + "' is not defined for this vo.");
            }
            if (r == null) {
                throw new NoSuchRoleException("Role '" + PathNamingScheme.getRoleName(contextString) + "' is not defined for this vo.");
            }
            return new VOMSContext(g, r);
        }
        throw new IllegalArgumentException("incorrect context string passed as argument to constructor!");
    }

    public boolean isGroupContext() {
        return this.getRole() == null;
    }

    public ACL getACL() {
        if (this.isGroupContext()) {
            return this.getGroup().getACL();
        }
        return this.getRole().getACL(this.getGroup());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.group != null) {
            buf.append(this.group.getName());
        }
        if (this.role != null) {
            buf.append("/" + this.role);
        }
        return buf.toString();
    }

    public static VOMSContext getVoContext() {
        return VOMSContext.instance(VOMSGroupDAO.instance().getVOGroup());
    }
}

