/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class VOMSPermission
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final int CONTAINER_READ = 1;
    public static final int CONTAINER_WRITE = 2;
    public static final int MEMBERSHIP_READ = 4;
    public static final int MEMBERSHIP_WRITE = 8;
    public static final int ACL_READ = 16;
    public static final int ACL_WRITE = 32;
    public static final int ACL_DEFAULT = 64;
    public static final int REQUESTS_READ = 128;
    public static final int REQUESTS_WRITE = 256;
    public static final int ATTRIBUTES_READ = 512;
    public static final int ATTRIBUTES_WRITE = 1024;
    public static final int GRANT = 2048;
    private static final int NUM_PERMISSIONS = 12;
    private static final int ALL_PERMISSION_MASK = 4095;
    private int bits = 0;

    public VOMSPermission() {
    }

    public VOMSPermission(int bits) {
        this.bits = bits;
    }

    protected boolean test(int permission) {
        if (permission <= 0) {
            throw new IllegalArgumentException("Permission must be a positive integer.");
        }
        return (this.bits & permission) == permission;
    }

    protected VOMSPermission set(int permission) {
        if (permission <= 0) {
            throw new IllegalArgumentException("Permission must be a positive integer.");
        }
        this.bits |= permission;
        return this;
    }

    protected VOMSPermission unset(int permission) {
        if (permission <= 0) {
            throw new IllegalArgumentException("Permission must be a positive integer.");
        }
        this.bits &= ~permission;
        return this;
    }

    public int getBits() {
        return this.bits;
    }

    private List buildPermList() {
        ArrayList<String> permList = new ArrayList<String>();
        if (this.test(1)) {
            permList.add("CONTAINER_READ");
        }
        if (this.test(2)) {
            permList.add("CONTAINER_WRITE");
        }
        if (this.test(4)) {
            permList.add("MEMBERSHIP_READ");
        }
        if (this.test(8)) {
            permList.add("MEMBERSHIP_WRITE");
        }
        if (this.test(16)) {
            permList.add("ACL_READ");
        }
        if (this.test(32)) {
            permList.add("ACL_WRITE");
        }
        if (this.test(64)) {
            permList.add("ACL_DEFAULT");
        }
        if (this.test(128)) {
            permList.add("REQUESTS_READ");
        }
        if (this.test(256)) {
            permList.add("REQUESTS_WRITE");
        }
        if (this.test(512)) {
            permList.add("ATTRIBUTES_READ");
        }
        if (this.test(1024)) {
            permList.add("ATTRIBUTES_WRITE");
        }
        if (this.test(2048)) {
            permList.add("GRANT");
        }
        return permList;
    }

    public String[] toStringArray() {
        if (this.bits == 0) {
            return null;
        }
        List permList = this.buildPermList();
        String[] result = new String[permList.size()];
        permList.toArray(result);
        permList.clear();
        permList = null;
        return result;
    }

    public String getCompactRepresentation() {
        StringBuffer buf = new StringBuffer();
        if (this.bits == 0) {
            return "NONE";
        }
        if (this.test(4095)) {
            return "ALL";
        }
        buf.append("C:");
        buf.append(this.test(1) ? "r" : "-");
        buf.append(this.test(2) ? "w" : "-");
        buf.append(" M:");
        buf.append(this.test(4) ? "r" : "-");
        buf.append(this.test(8) ? "w" : "-");
        buf.append(" Acl:");
        buf.append(this.test(16) ? "r" : "-");
        buf.append(this.test(32) ? "w" : "-");
        if (this.test(64)) {
            buf.append("d");
        }
        buf.append(" Attrs:");
        buf.append(this.test(512) ? "r" : "-");
        buf.append(this.test(1024) ? "w" : "-");
        buf.append(" Req:");
        buf.append(this.test(128) ? "r" : "-");
        buf.append(this.test(256) ? "w" : "-");
        return buf.toString();
    }

    public String toString() {
        if (this.test(4095)) {
            return "ALL";
        }
        if (this.bits == 0) {
            return "NONE";
        }
        List permList = this.buildPermList();
        String result = StringUtils.join(permList.iterator(), (String)",");
        permList.clear();
        permList = null;
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VOMSPermission)) {
            return false;
        }
        VOMSPermission that = (VOMSPermission)other;
        return this.bits == that.bits;
    }

    public int hashCode() {
        return new Integer(this.bits).hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        VOMSPermission clone = (VOMSPermission)super.clone();
        clone.bits = this.bits;
        return clone;
    }

    public boolean hasContainerReadPermission() {
        return this.test(1);
    }

    public boolean hasContainerWritePermission() {
        return this.test(2);
    }

    public boolean hasMembershipReadPermission() {
        return this.test(4);
    }

    public boolean hasMembershipWritePermission() {
        return this.test(8);
    }

    public boolean hasACLReadPermission() {
        return this.test(16);
    }

    public boolean hasACLWritePermission() {
        return this.test(32);
    }

    public boolean hasACLDefaultPermission() {
        return this.test(64);
    }

    public boolean hasRequestReadPermission() {
        return this.test(128);
    }

    public boolean hasRequestWritePermission() {
        return this.test(256);
    }

    public boolean hasAttributeReadPermission() {
        return this.test(512);
    }

    public boolean hasAttributeWritePermission() {
        return this.test(1024);
    }

    public boolean hasGrantPermission() {
        return this.test(2048);
    }

    public VOMSPermission setContainerReadPermission() {
        this.set(1);
        return this;
    }

    public VOMSPermission setContainerWritePermission() {
        this.set(2);
        return this;
    }

    public VOMSPermission setMembershipReadPermission() {
        this.set(4);
        return this;
    }

    public VOMSPermission setMembershipWritePermission() {
        this.set(8);
        return this;
    }

    public VOMSPermission setMembershipRWPermission() {
        this.set(4);
        this.set(8);
        return this;
    }

    public VOMSPermission setACLReadPermission() {
        this.set(16);
        return this;
    }

    public VOMSPermission setACLWritePermission() {
        this.set(32);
        return this;
    }

    public VOMSPermission setACLDefaultPermission() {
        this.set(64);
        return this;
    }

    public VOMSPermission setRequestsReadPermission() {
        this.set(128);
        return this;
    }

    public VOMSPermission setRequestsWritePermission() {
        this.set(256);
        return this;
    }

    public VOMSPermission setAttributesReadPermission() {
        this.set(512);
        return this;
    }

    public VOMSPermission setAttributesWritePermission() {
        this.set(1024);
        return this;
    }

    public VOMSPermission setGrantPermission() {
        this.set(2048);
        return this;
    }

    public VOMSPermission unsetContainerReadPermission() {
        this.unset(1);
        return this;
    }

    public VOMSPermission unsetContainerWritePermission() {
        this.unset(2);
        return this;
    }

    public VOMSPermission unsetMembershipReadPermission() {
        this.unset(4);
        return this;
    }

    public VOMSPermission unsetMembershipWritePermission() {
        this.unset(8);
        return this;
    }

    public VOMSPermission unsetACLReadPermission() {
        this.unset(16);
        return this;
    }

    public VOMSPermission unsetACLWritePermission() {
        this.unset(32);
        return this;
    }

    public VOMSPermission unsetACLDefaultPermission() {
        this.unset(64);
        return this;
    }

    public VOMSPermission unsetRequestsReadPermission() {
        this.unset(128);
        return this;
    }

    public VOMSPermission unsetRequestsWritePermission() {
        this.unset(256);
        return this;
    }

    public VOMSPermission unsetAttributesReadPermission() {
        this.unset(512);
        return this;
    }

    public VOMSPermission unsetAttributesWritePermission() {
        this.unset(1024);
        return this;
    }

    public VOMSPermission unsetGrantPermission() {
        this.unset(2048);
        return this;
    }

    public VOMSPermission setAllPermissions() {
        this.set(4095);
        return this;
    }

    public VOMSPermission setEmptyPermissions() {
        this.bits = 0;
        return this;
    }

    public VOMSPermission setPermissions(int bits) {
        this.set(bits);
        return this;
    }

    public boolean satisfies(VOMSPermission other) {
        int perms = this.bits & other.getBits();
        return perms == other.getBits();
    }

    public static String asString(int bits) {
        VOMSPermission p = new VOMSPermission(bits);
        return p.toString();
    }

    public static VOMSPermission getContainerRWPermissions() {
        return new VOMSPermission().setContainerReadPermission().setContainerWritePermission();
    }

    public static VOMSPermission getMembershipRWPermissions() {
        return new VOMSPermission().setMembershipReadPermission().setMembershipWritePermission();
    }

    public static VOMSPermission getContainerReadPermission() {
        return new VOMSPermission().setContainerReadPermission();
    }

    public static VOMSPermission getAllPermissions() {
        return new VOMSPermission().setAllPermissions();
    }

    public static VOMSPermission getEmptyPermissions() {
        return new VOMSPermission().setEmptyPermissions();
    }

    public static VOMSPermission getAttributesRWPermissions() {
        return new VOMSPermission().setAttributesReadPermission().setAttributesWritePermission();
    }

    public static VOMSPermission getRequestsRWPermissions() {
        return new VOMSPermission().setRequestsReadPermission().setRequestsWritePermission();
    }

    public String toBinaryString() {
        return Integer.toBinaryString(this.bits);
    }

    public static VOMSPermission fromStringArray(String[] perms) {
        VOMSPermission perm = new VOMSPermission();
        for (int i = 0; i < perms.length; ++i) {
            if (perms[i].equals("CONTAINER_READ")) {
                perm.setContainerReadPermission();
                continue;
            }
            if (perms[i].equals("CONTAINER_WRITE")) {
                perm.setContainerWritePermission();
                continue;
            }
            if (perms[i].equals("MEMBERSHIP_READ")) {
                perm.setMembershipReadPermission();
                continue;
            }
            if (perms[i].equals("MEMBERSHIP_WRITE")) {
                perm.setMembershipWritePermission();
                continue;
            }
            if (perms[i].equals("ACL_READ")) {
                perm.setACLReadPermission();
                continue;
            }
            if (perms[i].equals("ACL_WRITE")) {
                perm.setACLWritePermission();
                continue;
            }
            if (perms[i].equals("ACL_DEFAULT")) {
                perm.setACLDefaultPermission();
                continue;
            }
            if (perms[i].equals("REQUESTS_READ")) {
                perm.setRequestsReadPermission();
                continue;
            }
            if (perms[i].equals("REQUESTS_WRITE")) {
                perm.setRequestsWritePermission();
                continue;
            }
            if (perms[i].equals("ATTRIBUTES_READ")) {
                perm.setAttributesReadPermission();
                continue;
            }
            if (perms[i].equals("ATTRIBUTES_WRITE")) {
                perm.setAttributesWritePermission();
                continue;
            }
            if (perms[i].equals("GRANT")) {
                perm.setGrantPermission();
                continue;
            }
            if (perms[i].equals("ALL")) {
                perm.setAllPermissions();
                continue;
            }
            if (perms[i].equals("NONE")) {
                perm.setEmptyPermissions();
                continue;
            }
            throw new IllegalArgumentException("Unknown permission passed as argument: " + perms[i]);
        }
        return perm;
    }

    public static VOMSPermission fromString(String permString) {
        VOMSPermission perm = new VOMSPermission();
        String[] perms = StringUtils.split((String)permString, (char)'|');
        if (perms.length == 1 && perms[0].equals("")) {
            return perm;
        }
        return VOMSPermission.fromStringArray(perms);
    }

    public static VOMSPermission fromBits(int bits) {
        if (bits <= 0) {
            throw new IllegalArgumentException("Permission must be a positive integer.");
        }
        VOMSPermission perm = new VOMSPermission();
        for (int i = 0; i < 12; ++i) {
            int PERM_MASK = 1 << i;
            if ((bits & PERM_MASK) != PERM_MASK) continue;
            perm.set(PERM_MASK);
        }
        return perm;
    }
}

