/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.acls;

import java.util.Map;
import org.glite.security.voms.admin.common.NullArgumentException;
import org.glite.security.voms.admin.common.VOMSAuthorizationException;
import org.glite.security.voms.admin.model.ACL;
import org.glite.security.voms.admin.model.VOMSAdmin;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSPermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetACLOperation
extends BaseVomsOperation {
    Map<VOMSAdmin, VOMSPermission> permissions;
    ACL theACL;

    private SetACLOperation(ACL acl, Map<VOMSAdmin, VOMSPermission> perms) {
        if (acl == null) {
            throw new NullArgumentException("acl cannot be null!");
        }
        if (perms == null) {
            throw new NullArgumentException("perms cannot be null!");
        }
        this.theACL = acl;
        this.permissions = perms;
    }

    public static SetACLOperation instance(ACL acl, Map<VOMSAdmin, VOMSPermission> perms) {
        return new SetACLOperation(acl, perms);
    }

    @Override
    protected Object doExecute() {
        if (this.permissions.isEmpty() && !this.theACL.isDefautlACL()) {
            throw new VOMSAuthorizationException("Will not replace the current ACL with an empty one.");
        }
        this.theACL.getPermissions().clear();
        this.theACL.getPermissions().putAll(this.permissions);
        return null;
    }

    @Override
    protected void setupPermissions() {
        VOMSPermission perms = VOMSPermission.getEmptyPermissions().setACLReadPermission().setACLWritePermission();
        if (this.theACL.isDefautlACL()) {
            perms.setACLDefaultPermission();
        }
        this.addRequiredPermission(this.theACL.getContext(), perms);
    }
}

