/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.groups;

import org.glite.security.voms.admin.dao.VOMSUserDAO;
import org.glite.security.voms.admin.database.NoSuchGroupException;
import org.glite.security.voms.admin.database.NoSuchUserException;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSUser;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.operations.groups.FindGroupOperation;
import org.glite.security.voms.admin.operations.users.FindUserOperation;

public class AddMemberOperation
extends BaseVomsOperation {
    VOMSUser user;
    VOMSGroup group;

    public AddMemberOperation(VOMSUser u, VOMSGroup g) {
        this.user = u;
        this.group = g;
    }

    public Object doExecute() {
        if (!this.group.isRootGroup() && !this.user.isMember(this.group.getParent())) {
            AddMemberOperation.instance(this.user, this.group.getParent()).execute();
        }
        VOMSUserDAO.instance().addToGroup(this.user, this.group);
        return null;
    }

    public static AddMemberOperation instance(VOMSUser u, VOMSGroup g) {
        return new AddMemberOperation(u, g);
    }

    public static AddMemberOperation instance(String groupName, String username, String caDn) {
        VOMSUser u = (VOMSUser)FindUserOperation.instance(username, caDn).execute();
        VOMSGroup g = (VOMSGroup)FindGroupOperation.instance(groupName).execute();
        if (u == null) {
            throw new NoSuchUserException("User '" + username + "," + caDn + "' not found in this vo.");
        }
        if (g == null) {
            throw new NoSuchGroupException("Group '" + groupName + "' does not exist in this vo.");
        }
        return new AddMemberOperation(u, g);
    }

    protected void setupPermissions() {
        this.addRequiredPermission(VOMSContext.instance(this.group.getParent()), VOMSPermission.getContainerReadPermission());
        this.addRequiredPermission(VOMSContext.instance(this.group), VOMSPermission.getMembershipRWPermissions());
    }
}

