/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.groups;

import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.admin.common.PathNamingScheme;
import org.glite.security.voms.admin.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSRole;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.operations.roles.ListRolesOperation;

public class CreateGroupOperation
extends BaseVomsOperation {
    private static final Log log = LogFactory.getLog(CreateGroupOperation.class);
    String groupName;

    private CreateGroupOperation(String name) {
        this.groupName = name;
    }

    private void setupACLs(VOMSGroup g) {
        log.debug((Object)("Setting up acls for group '" + g + "'."));
        if (g.getParent().getDefaultACL() != null) {
            g.importACL(g.getParent().getDefaultACL());
        } else {
            g.importACL(g.getParent().getACL());
        }
        List roles = (List)ListRolesOperation.instance().execute();
        for (VOMSRole r : roles) {
            log.debug((Object)("Importing group '" + g + "' acl in role '" + r + "'."));
            r.importACL(g);
            HibernateFactory.getSession().save((Object)r);
        }
    }

    protected Object doExecute() {
        VOMSGroup g = VOMSGroupDAO.instance().create(this.groupName);
        this.setupACLs(g);
        HibernateFactory.getSession().save((Object)g);
        return g;
    }

    public static CreateGroupOperation instance(String groupName) {
        return new CreateGroupOperation(groupName);
    }

    protected void setupPermissions() {
        String parentGroupName = PathNamingScheme.getParentGroupName(this.groupName);
        VOMSGroup parentGroup = VOMSGroupDAO.instance().findByName(parentGroupName);
        this.addPermissionsOnPath(parentGroup, VOMSPermission.getContainerReadPermission());
        this.addRequiredPermission(VOMSContext.instance(parentGroup), VOMSPermission.getContainerRWPermissions());
        if (!parentGroup.isRootGroup()) {
            this.addRequiredPermission(VOMSContext.getVoContext(), VOMSPermission.getContainerRWPermissions());
        }
        if (log.isDebugEnabled()) {
            this.logRequiredPermissions();
        }
    }

    protected String logArgs() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

