/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.groups;

import org.glite.security.voms.admin.common.PathNamingScheme;
import org.glite.security.voms.admin.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;

public class FindGroupOperation
extends BaseVomsOperation {
    Long id = null;
    String name = null;

    private FindGroupOperation(Long id) {
        this.id = id;
    }

    private FindGroupOperation(String name) {
        this.name = name;
    }

    protected Object doExecute() {
        if (this.id != null) {
            return VOMSGroupDAO.instance().findById(this.id);
        }
        if (this.name != null) {
            return VOMSGroupDAO.instance().findByName(this.name);
        }
        return null;
    }

    public static FindGroupOperation instance(Long id) {
        return new FindGroupOperation(id);
    }

    public static FindGroupOperation instance(String name) {
        return new FindGroupOperation(name);
    }

    protected void setupPermissions() {
        if (this.name != null) {
            String parentGroupName = PathNamingScheme.getParentGroupName(this.name);
            VOMSContext ctxt = VOMSContext.instance(VOMSGroupDAO.instance().findByName(parentGroupName));
            this.addRequiredPermission(ctxt, VOMSPermission.getContainerReadPermission());
        } else if (this.id != null) {
            VOMSGroup parentGroup = VOMSGroupDAO.instance().findById(this.id).getParent();
            VOMSContext ctxt = VOMSContext.instance(parentGroup);
            this.addRequiredPermission(ctxt, VOMSPermission.getContainerReadPermission());
        }
    }
}

