/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.requests;

import java.util.Date;
import org.glite.security.voms.admin.common.IllegalRequestStateException;
import org.glite.security.voms.admin.dao.RequestDAO;
import org.glite.security.voms.admin.database.NoSuchRequestException;
import org.glite.security.voms.admin.model.VOMembershipRequest;
import org.glite.security.voms.admin.notification.RequestApprovedNotification;
import org.glite.security.voms.admin.operations.requests.LoadVOMembershipRequestOperation;
import org.glite.security.voms.admin.operations.requests.RequestRWOperation;
import org.glite.security.voms.admin.operations.users.CreateUserOperation;

public class ApproveVOMembershipOperation
extends RequestRWOperation {
    Long requestId;

    private ApproveVOMembershipOperation(Long reqId) {
        this.requestId = reqId;
    }

    protected Object doExecute() {
        VOMembershipRequest req = (VOMembershipRequest)LoadVOMembershipRequestOperation.instance(this.requestId).execute();
        if (req == null) {
            throw new NoSuchRequestException("No request found with id " + this.requestId);
        }
        if (!req.getStatus().equals(VOMembershipRequest.CONFIRMED)) {
            throw new IllegalRequestStateException("Illegal state for request!");
        }
        CreateUserOperation.instance(req.getDn(), req.getCa(), req.getCn(), null, req.getEmailAddress()).execute();
        req.setStatus(VOMembershipRequest.APPROVED);
        req.setEvaluationDate(new Date());
        RequestDAO.instance().save(req);
        RequestApprovedNotification n = new RequestApprovedNotification(req.getEmailAddress());
        n.send();
        return req;
    }

    public static ApproveVOMembershipOperation instance(Long reqId) {
        return new ApproveVOMembershipOperation(reqId);
    }
}

