/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.requests;

import java.util.Date;
import org.glite.security.voms.admin.common.IllegalRequestStateException;
import org.glite.security.voms.admin.dao.RequestDAO;
import org.glite.security.voms.admin.database.NoSuchRequestException;
import org.glite.security.voms.admin.model.VOMembershipRequest;
import org.glite.security.voms.admin.notification.RequestRejectedNotification;
import org.glite.security.voms.admin.operations.requests.LoadVOMembershipRequestOperation;
import org.glite.security.voms.admin.operations.requests.RequestRWOperation;

public class RejectVOMembershipOperation
extends RequestRWOperation {
    Long requestId;

    private RejectVOMembershipOperation(Long reqId) {
        this.requestId = reqId;
    }

    protected Object doExecute() {
        VOMembershipRequest req = (VOMembershipRequest)LoadVOMembershipRequestOperation.instance(this.requestId).execute();
        if (req == null) {
            throw new NoSuchRequestException("No request found with id " + this.requestId);
        }
        if (!req.getStatus().equals(VOMembershipRequest.CONFIRMED)) {
            throw new IllegalRequestStateException("Illegal state for request!");
        }
        req.setStatus(VOMembershipRequest.REJECTED);
        req.setEvaluationDate(new Date());
        RequestDAO.instance().save(req);
        RequestRejectedNotification n = new RequestRejectedNotification(req.getEmailAddress(), "The VO admin didn't find appropriate to accept your request.");
        n.send();
        return req;
    }

    public static RejectVOMembershipOperation instance(Long reqId) {
        return new RejectVOMembershipOperation(reqId);
    }
}

