/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.roles;

import java.util.Iterator;
import java.util.List;
import org.glite.security.voms.admin.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSRole;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.operations.groups.ListGroupsOperation;

public class CreateRoleOperation
extends BaseVomsOperation {
    String roleName;

    private CreateRoleOperation(String roleName) {
        this.roleName = roleName;
    }

    private void setupACLs(VOMSRole r) {
        List groups = (List)ListGroupsOperation.instance().execute();
        Iterator groupsIter = groups.iterator();
        while (groupsIter.hasNext()) {
            r.importACL((VOMSGroup)groupsIter.next());
        }
    }

    protected Object doExecute() {
        VOMSRole r = VOMSRoleDAO.instance().create(this.roleName);
        this.setupACLs(r);
        HibernateFactory.getSession().save((Object)r);
        return r;
    }

    public static CreateRoleOperation instance(String roleName) {
        return new CreateRoleOperation(roleName);
    }

    protected void setupPermissions() {
        this.addRequiredPermission(VOMSContext.getVoContext(), VOMSPermission.getContainerRWPermissions());
    }
}

