/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.users;

import org.glite.security.voms.admin.dao.VOMSUserDAO;
import org.glite.security.voms.admin.database.NoSuchGroupException;
import org.glite.security.voms.admin.database.NoSuchRoleException;
import org.glite.security.voms.admin.database.NoSuchUserException;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSRole;
import org.glite.security.voms.admin.model.VOMSUser;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.operations.groups.FindGroupOperation;
import org.glite.security.voms.admin.operations.roles.FindRoleOperation;
import org.glite.security.voms.admin.operations.users.FindUserOperation;

public class AssignRoleOperation
extends BaseVomsOperation {
    VOMSUser user;
    VOMSGroup group;
    VOMSRole role;

    private AssignRoleOperation(VOMSUser u, VOMSGroup g, VOMSRole r) {
        this.user = u;
        this.group = g;
        this.role = r;
    }

    public Object doExecute() {
        VOMSUserDAO.instance().assignRole(this.user, this.group, this.role);
        return null;
    }

    public static AssignRoleOperation instance(VOMSUser u, VOMSGroup g, VOMSRole r) {
        return new AssignRoleOperation(u, g, r);
    }

    public static AssignRoleOperation instance(String groupName, String roleName, String userName, String caDn) {
        VOMSUser u = (VOMSUser)FindUserOperation.instance(userName, caDn).execute();
        VOMSGroup g = (VOMSGroup)FindGroupOperation.instance(groupName).execute();
        VOMSRole r = (VOMSRole)FindRoleOperation.instance(roleName).execute();
        if (u == null) {
            throw new NoSuchUserException("User '" + userName + "," + caDn + "' not found in org.glite.security.voms.admin.database.");
        }
        if (g == null) {
            throw new NoSuchGroupException("Group '" + groupName + "' not found in org.glite.security.voms.admin.database.");
        }
        if (r == null) {
            throw new NoSuchRoleException("Role '" + roleName + "' not found in org.glite.security.voms.admin.database.");
        }
        return new AssignRoleOperation(u, g, r);
    }

    protected void setupPermissions() {
        this.addRequiredPermission(VOMSContext.instance(this.group), VOMSPermission.getContainerReadPermission().setMembershipRWPermission());
    }
}

