/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.users;

import org.glite.security.voms.admin.dao.VOMSUserDAO;
import org.glite.security.voms.admin.database.NoSuchGroupException;
import org.glite.security.voms.admin.database.NoSuchRoleException;
import org.glite.security.voms.admin.database.NoSuchUserException;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSRole;
import org.glite.security.voms.admin.model.VOMSUser;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.operations.groups.FindGroupOperation;
import org.glite.security.voms.admin.operations.roles.FindRoleOperation;
import org.glite.security.voms.admin.operations.users.FindUserOperation;

public class DismissRoleOperation
extends BaseVomsOperation {
    VOMSUser user;
    VOMSGroup group;
    VOMSRole role;

    private DismissRoleOperation(VOMSUser u, VOMSGroup g, VOMSRole r) {
        this.user = u;
        this.group = g;
        this.role = r;
    }

    public VOMSContext getContext() {
        return VOMSContext.instance(this.group);
    }

    public VOMSPermission getRequiredPermission() {
        return VOMSPermission.getContainerRWPermissions();
    }

    public Object doExecute() {
        VOMSUserDAO.instance().dismissRole(this.user, this.group, this.role);
        return null;
    }

    public static DismissRoleOperation instance(String groupName, String roleName, String userName, String caDn) {
        VOMSUser u = (VOMSUser)FindUserOperation.instance(userName, caDn).execute();
        VOMSGroup g = (VOMSGroup)FindGroupOperation.instance(groupName).execute();
        VOMSRole r = (VOMSRole)FindRoleOperation.instance(roleName).execute();
        if (u == null) {
            throw new NoSuchUserException("User '" + userName + "," + caDn + "' not found in this vo.");
        }
        if (g == null) {
            throw new NoSuchGroupException("Group '" + groupName + "' does not exist in this vo.");
        }
        if (r == null) {
            throw new NoSuchRoleException("Role '" + roleName + "' does not exists in this vo.");
        }
        return new DismissRoleOperation(u, g, r);
    }

    public static DismissRoleOperation instance(VOMSUser u, VOMSGroup g, VOMSRole r) {
        return new DismissRoleOperation(u, g, r);
    }

    protected void setupPermissions() {
        this.addRequiredPermission(VOMSContext.instance(this.group), VOMSPermission.getContainerReadPermission().setMembershipRWPermission());
    }
}

