/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.users;

import org.glite.security.voms.admin.dao.VOMSUserDAO;
import org.glite.security.voms.admin.operations.BaseVoReadOperation;

public class FindUserOperation
extends BaseVoReadOperation {
    Long id;
    String dn = null;
    String caDN = null;
    String emailAddress = null;

    private FindUserOperation(Long userId) {
        this.id = userId;
    }

    private FindUserOperation(String dn, String ca) {
        this.dn = dn;
        this.caDN = ca;
    }

    private FindUserOperation(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    protected Object doExecute() {
        if (this.dn == null) {
            return VOMSUserDAO.instance().findById(this.id);
        }
        if (this.emailAddress == null) {
            return VOMSUserDAO.instance().findByName(this.dn, this.caDN);
        }
        return VOMSUserDAO.instance().findByEmail(this.emailAddress);
    }

    public static FindUserOperation instance(Long id) {
        return new FindUserOperation(id);
    }

    public static FindUserOperation instance(String dn, String caDN) {
        return new FindUserOperation(dn, caDN);
    }

    public static FindUserOperation instance(String emailAddress) {
        return new FindUserOperation(emailAddress);
    }
}

