/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.users;

import org.glite.security.voms.User;
import org.glite.security.voms.admin.dao.VOMSUserDAO;
import org.glite.security.voms.admin.database.NoSuchUserException;
import org.glite.security.voms.admin.model.VOMSUser;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.operations.users.FindUserOperation;
import org.glite.security.voms.service.attributes.AttributeValue;

public class SetUserAttributeOperation
extends BaseVomsOperation {
    VOMSUser user;
    String attributeName;
    String attributeDescription;
    String attributeValue;

    private SetUserAttributeOperation(VOMSUser u, String aName, String aDesc, String aValue) {
        this.user = u;
        this.attributeName = aName;
        this.attributeDescription = aDesc;
        this.attributeValue = aValue;
    }

    public Object doExecute() {
        return VOMSUserDAO.instance().setAttribute(this.user, this.attributeName, this.attributeValue);
    }

    public static SetUserAttributeOperation instance(VOMSUser u, String aName, String aDesc, String aValue) {
        return new SetUserAttributeOperation(u, aName, aDesc, aValue);
    }

    public static SetUserAttributeOperation instance(User user, AttributeValue val) {
        VOMSUser u = (VOMSUser)FindUserOperation.instance(user.getDN(), user.getCA()).execute();
        if (u == null) {
            throw new NoSuchUserException("User '" + user.getDN() + "," + user.getCA() + "' not found in this vo.");
        }
        return new SetUserAttributeOperation(u, val.getAttributeClass().getName(), val.getAttributeClass().getDescription(), val.getValue());
    }

    protected void setupPermissions() {
        this.addRequiredPermission(VOMSContext.getVoContext(), VOMSPermission.getAttributesRWPermissions());
    }
}

