/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.request;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.glite.security.voms.admin.request.Action;
import org.glite.security.voms.admin.request.ActionSequence;
import org.glite.security.voms.admin.request.BaseEvent;
import org.glite.security.voms.admin.request.BaseState;
import org.glite.security.voms.admin.request.BaseTransition;
import org.glite.security.voms.admin.request.Event;
import org.glite.security.voms.admin.request.Flow;
import org.glite.security.voms.admin.request.IllegalTargetStateException;
import org.glite.security.voms.admin.request.NoSuchTransitionException;
import org.glite.security.voms.admin.request.State;
import org.glite.security.voms.admin.request.StateMachineException;
import org.glite.security.voms.admin.request.TransitionLog;
import org.glite.security.voms.admin.request.TransitionMap;

public class StateMachine
implements Flow {
    private static final Log log = LogFactory.getLog(StateMachine.class);
    TransitionMap map = new TransitionMap();
    TransitionLog tLog = new TransitionLog();
    State currentState;
    State initialState;
    ActionSequence preTransitionActions = new ActionSequence();
    ActionSequence postTransitionActions = new ActionSequence();

    public StateMachine(State s, TransitionMap m) {
        this.currentState = this.initialState = s;
        this.map = m;
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public State process(Event e) {
        log.debug((Object)("Processing event: " + e));
        State targetState = this.map.getTargetState(this.currentState, e);
        if (targetState == null) {
            this.logAndThrowException(new NoSuchTransitionException("(" + this.currentState + "," + e + ")-->?"));
        }
        if (!this.map.containsKey(targetState)) {
            this.logAndThrowException(new IllegalTargetStateException(targetState.toString()));
        }
        this.logTransition(targetState, e);
        this.preTransitionActions.execute();
        this.currentState = targetState;
        this.currentState.executeActions();
        this.postTransitionActions.execute();
        if (this.inFinalState()) {
            log.debug((Object)("Reached final state: " + this.currentState));
        }
        return this.currentState;
    }

    public boolean inFinalState() {
        return this.map.isFinalState(this.currentState);
    }

    private void logAndThrowException(StateMachineException e) {
        this.tLog.logException(this.currentState, e);
        throw e;
    }

    private void logTransition(State targetState, Event e) {
        log.debug((Object)("Transition:(" + this.currentState + "," + e + ")-->" + targetState));
        this.tLog.logTransition(this.currentState, targetState, e);
    }

    public static void main(String[] args) {
        PropertyConfigurator.configure((String)"./src/log4j.test.properties");
        BaseState initialState = new BaseState("WAITING");
        BaseState finalState = new BaseState("DONE");
        BaseEvent signal = new BaseEvent("signal");
        TransitionMap map = new TransitionMap();
        map.addStates(new State[]{initialState, finalState});
        map.addTransition(initialState, new BaseTransition(signal, finalState));
        StateMachine sm = new StateMachine(initialState, map);
        sm.process(signal);
        log.debug((Object)sm.map);
        log.debug((Object)sm.tLog);
    }

    public void addStates(State[] states) {
        this.map.addStates(states);
    }

    public void addStates(String[] stateNames) {
        this.map.addStates(stateNames);
    }

    public void addTransition(String initialStateName, Event e, String finalStateName) {
        this.map.addTransition(initialStateName, e, finalStateName);
    }

    public State getState(String name) {
        return this.map.getState(name);
    }

    public void addPreTransitionAction(Action a) {
        this.preTransitionActions.addAction(a);
    }

    public void addPostTransitionAction(Action a) {
        this.postTransitionActions.addAction(a);
    }
}

