/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.request;

import java.util.Date;
import org.glite.security.voms.admin.request.Event;
import org.glite.security.voms.admin.request.State;
import org.glite.security.voms.admin.request.StateMachineException;

public class TransitionLogEntry
implements Comparable {
    private Date time;
    private State initialState;
    private State finalState;
    private Event cause;
    private StateMachineException exception;

    private TransitionLogEntry(Date time, State s, State t, Event c) {
        this.time = time;
        this.initialState = s;
        this.finalState = t;
        this.cause = c;
    }

    private TransitionLogEntry(Date time, State s, StateMachineException ex) {
        this.time = time;
        this.initialState = s;
        this.exception = ex;
    }

    public StateMachineException getException() {
        return this.exception;
    }

    public void setException(StateMachineException exception) {
        this.exception = exception;
    }

    public Event getCause() {
        return this.cause;
    }

    public void setCause(Event cause) {
        this.cause = cause;
    }

    public State getFinalState() {
        return this.finalState;
    }

    public void setFinalState(State finalState) {
        this.finalState = finalState;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public State getInitialState() {
        return this.initialState;
    }

    public void setInitialState(State initialState) {
        this.initialState = initialState;
    }

    public static TransitionLogEntry instance(State initialState, State finalState, Event cause) {
        TransitionLogEntry entry = new TransitionLogEntry(new Date(), initialState, finalState, cause);
        return entry;
    }

    public static TransitionLogEntry instance(State initialState, StateMachineException e) {
        TransitionLogEntry entry = new TransitionLogEntry(new Date(), initialState, e);
        return entry;
    }

    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        TransitionLogEntry that = (TransitionLogEntry)o;
        return this.time.compareTo(that.time);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<");
        buf.append(this.time);
        buf.append("," + this.initialState);
        if (this.exception == null) {
            buf.append(":" + this.cause + "-->" + this.finalState);
        } else {
            buf.append(": exception " + this.exception);
        }
        buf.append(">");
        return buf.toString();
    }
}

