/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.request;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glite.security.voms.admin.request.BaseState;
import org.glite.security.voms.admin.request.BaseTransition;
import org.glite.security.voms.admin.request.Event;
import org.glite.security.voms.admin.request.State;
import org.glite.security.voms.admin.request.Transition;

public class TransitionMap {
    Map map = new HashMap();

    public void addTransition(String initialStateName, Event e, String finalStateName) {
        State initialState = this.getState(initialStateName);
        State finalState = this.getState(finalStateName);
        this.addTransition(initialState, new BaseTransition(e, finalState));
    }

    public void addTransition(State initialState, Transition t) {
        HashSet<Transition> transitions = (HashSet<Transition>)this.map.get(initialState);
        if (transitions == null) {
            transitions = new HashSet<Transition>();
            transitions.add(t);
            this.map.put(initialState, transitions);
        } else {
            if (transitions.contains(t)) {
                return;
            }
            transitions.add(t);
        }
    }

    public State getTargetState(State initialState, Event receivedEvent) {
        Set transitions = (Set)this.map.get(initialState);
        if (transitions == null) {
            return null;
        }
        for (Transition t : transitions) {
            if (!t.getEvent().equals(receivedEvent)) continue;
            return t.getTargetState();
        }
        return null;
    }

    public void addStates(String[] stateNames) {
        for (int i = 0; i < stateNames.length; ++i) {
            this.map.put(new BaseState(stateNames[i]), null);
        }
    }

    public void addStates(State[] states) {
        for (int i = 0; i < states.length; ++i) {
            this.map.put(states[i], null);
        }
    }

    public State getState(String name) {
        BaseState s = new BaseState(name);
        if (this.map.containsKey(s)) {
            return s;
        }
        return null;
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean isFinalState(State s) {
        Set transitions = (Set)this.map.get(s);
        return transitions != null ? transitions.isEmpty() : true;
    }

    public String toString() {
        if (this.map.isEmpty()) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        for (Object key : this.map.keySet()) {
            buf.append("\n" + key + ":" + this.map.get(key));
        }
        return buf.toString();
    }
}

