/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.request;

import java.util.Calendar;
import java.util.Date;
import org.glite.security.voms.admin.common.VOMSConfiguration;
import org.glite.security.voms.admin.request.AbstractRequest;
import org.glite.security.voms.admin.request.Event;
import org.glite.security.voms.admin.request.State;

public class VOMembershipRequest
extends AbstractRequest {
    public Date getExpirationTime() {
        int expirationTimeInMinutes = VOMSConfiguration.instance().getInt("voms.request.vo-membership-expiration-time");
        Calendar c = Calendar.getInstance();
        c.setTime(this.creationTime);
        c.add(12, expirationTimeInMinutes);
        return c.getTime();
    }

    public boolean hasExpired() {
        Date now = new Date();
        return this.getExpirationTime().compareTo(now) > 0;
    }

    public State getCurrentState() {
        return this.stateMachine.getCurrentState();
    }

    public State process(Event e) {
        return this.stateMachine.process(e);
    }

    public boolean inFinalState() {
        return this.stateMachine.inFinalState();
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }
}

