/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.glite.security.voms.admin.common.NullArgumentException;
import org.glite.security.voms.admin.common.VOMSConfiguration;
import org.glite.security.voms.admin.dao.VOMSAdminDAO;
import org.glite.security.voms.admin.model.ACL;
import org.glite.security.voms.admin.model.VOMSAdmin;
import org.glite.security.voms.admin.model.VOMSAttributeDescription;
import org.glite.security.voms.admin.model.VOMSBaseAttribute;
import org.glite.security.voms.admin.model.VOMSCA;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.service.acl.ACLEntry;
import org.glite.security.voms.service.attributes.AttributeClass;
import org.glite.security.voms.service.attributes.AttributeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceUtils {
    public static AttributeValue[] toAttributeValueArray(Collection attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return null;
        }
        AttributeValue[] values = new AttributeValue[attributes.size()];
        Iterator i = attributes.iterator();
        int index = 0;
        while (i.hasNext()) {
            values[index++] = ((VOMSBaseAttribute)i.next()).asAttributeValue();
        }
        return values;
    }

    public static AttributeClass[] toAttributeClassArray(List descriptions) {
        if (descriptions == null || descriptions.isEmpty()) {
            return null;
        }
        AttributeClass[] classes = new AttributeClass[descriptions.size()];
        Iterator i = descriptions.iterator();
        int index = 0;
        while (i.hasNext()) {
            classes[index++] = ((VOMSAttributeDescription)i.next()).asAttributeClass();
        }
        return classes;
    }

    public static String[] rolesToStringArray(Collection c) {
        if (c == null || c.isEmpty()) {
            return null;
        }
        String[] res = new String[c.size()];
        int index = 0;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            res[index++] = i.next().toString();
        }
        return res;
    }

    public static String[] groupsToStringArray(Collection c) {
        if (c == null || c.isEmpty()) {
            return null;
        }
        String[] res = new String[c.size()];
        int index = 0;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            res[index++] = ((VOMSGroup)i.next()).getName();
        }
        return res;
    }

    public static String[] casToStringArray(Collection c) {
        if (c == null || c.isEmpty()) {
            return null;
        }
        String[] res = new String[c.size()];
        int index = 0;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            res[index++] = ((VOMSCA)i.next()).getDn();
        }
        return res;
    }

    public static String[] toStringArray(Collection c) {
        if (c == null || c.isEmpty()) {
            return null;
        }
        String[] res = new String[c.size()];
        int index = 0;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            res[index++] = i.next().toString();
        }
        return res;
    }

    public static ACLEntry[] toACLEntryArray(ACL acl) {
        if (acl == null || acl.getPermissions().isEmpty()) {
            return null;
        }
        ACLEntry[] entries = new ACLEntry[acl.getPermissions().size()];
        int index = 0;
        for (VOMSAdmin admin : acl.getPermissions().keySet()) {
            VOMSPermission perms = acl.getPermissions(admin);
            ACLEntry entry = new ACLEntry();
            entry.setAdminSubject(admin.getDn());
            entry.setAdminIssuer(admin.getCa().getDn());
            entry.setVomsPermissionBits(perms.getBits());
            entries[index++] = entry;
        }
        return entries;
    }

    public static Map<VOMSAdmin, VOMSPermission> toPermissionMap(ACLEntry[] entries) {
        if (entries == null || entries.length == 0) {
            throw new NullArgumentException("entries cannot be null or empty!");
        }
        HashMap<VOMSAdmin, VOMSPermission> map = new HashMap<VOMSAdmin, VOMSPermission>();
        for (ACLEntry e : entries) {
            VOMSAdmin admin = VOMSAdminDAO.instance().getByName(e.getAdminSubject(), e.getAdminIssuer());
            VOMSPermission perm = VOMSPermission.fromBits(e.getVomsPermissionBits());
            if (admin == null) continue;
            map.put(admin, perm);
        }
        return map;
    }

    public static List<String> decorateDNList(List<String> l) {
        ArrayList<String> returnValue = new ArrayList<String>();
        for (String dn : l) {
            if (!dn.contains("Email")) continue;
            returnValue.add(dn.replaceAll("Email=", "emailAddress="));
        }
        returnValue.addAll(l);
        return returnValue;
    }

    public static String getBaseContext(HttpServletRequest request) {
        String result = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + "/voms/" + VOMSConfiguration.instance().getVOName();
        return result;
    }
}

