/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.service;

import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.VOMSException;
import org.glite.security.voms.admin.common.NullArgumentException;
import org.glite.security.voms.admin.common.PathNamingScheme;
import org.glite.security.voms.admin.dao.ACLDAO;
import org.glite.security.voms.admin.dao.VOMSAdminDAO;
import org.glite.security.voms.admin.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.glite.security.voms.admin.database.NoSuchACLException;
import org.glite.security.voms.admin.database.NoSuchAdminException;
import org.glite.security.voms.admin.database.NoSuchGroupException;
import org.glite.security.voms.admin.database.NoSuchRoleException;
import org.glite.security.voms.admin.model.ACL;
import org.glite.security.voms.admin.model.VOMSAdmin;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSRole;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.operations.acls.DeleteACLEntryOperation;
import org.glite.security.voms.admin.operations.acls.LoadACLOperation;
import org.glite.security.voms.admin.operations.acls.SaveACLEntryOperation;
import org.glite.security.voms.admin.operations.acls.SetACLOperation;
import org.glite.security.voms.admin.operations.groups.FindGroupOperation;
import org.glite.security.voms.admin.service.ServiceExceptionHelper;
import org.glite.security.voms.admin.service.ServiceUtils;
import org.glite.security.voms.service.acl.ACLEntry;
import org.glite.security.voms.service.acl.VOMSACL;

public class VOMSACLService
implements VOMSACL {
    private static final Log log = LogFactory.getLog(VOMSACLService.class);

    public void addACLEntry(String container, ACLEntry entry, boolean propagateToChildrenContexts) throws RemoteException, VOMSException {
        log.info((Object)("addACLEntry('container=" + container + "', entry='" + entry + "');"));
        if (container == null) {
            throw new NullArgumentException("Container cannot be null!");
        }
        if (entry == null) {
            throw new NullArgumentException("Container cannot be null!");
        }
        try {
            ACL theACL = (ACL)LoadACLOperation.instance(container).execute();
            VOMSAdmin theAdmin = this.getAdminFromEntry(entry);
            if (theAdmin == null) {
                throw new NoSuchAdminException("Unknown or illegal admin! '" + entry.getAdminSubject() + "," + entry.getAdminIssuer() + "'");
            }
            VOMSPermission perms = VOMSPermission.fromBits(entry.getVomsPermissionBits());
            SaveACLEntryOperation.instance(theACL, theAdmin, perms, propagateToChildrenContexts).execute();
            HibernateFactory.commitTransaction();
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public void addDefaultACLEntry(String group, ACLEntry entry) throws RemoteException, VOMSException {
        log.info((Object)("addDefaultACLEntry(" + StringUtils.join((Object[])new Object[]{group, entry}, (char)',') + ");"));
        if (group == null) {
            throw new NullArgumentException("group cannot be null!");
        }
        if (entry == null) {
            throw new NullArgumentException("entry cannot be null!");
        }
        VOMSGroup g = null;
        try {
            g = (VOMSGroup)FindGroupOperation.instance(group).execute();
            if (g == null) {
                throw new NoSuchGroupException("Group '" + g + "' not found in database!");
            }
            ACL acl = g.getDefaultACL();
            if (acl == null) {
                acl = ACLDAO.instance().create(g, true);
            }
            VOMSAdmin theAdmin = this.getAdminFromEntry(entry);
            VOMSPermission perms = VOMSPermission.fromBits(entry.getVomsPermissionBits());
            SaveACLEntryOperation.instance(acl, theAdmin, perms).execute();
            HibernateFactory.commitTransaction();
        }
        catch (RuntimeException e) {
            log.error((Object)e);
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (g != null && g.getDefaultACL() != null && g.getDefaultACL().getPermissions().isEmpty()) {
                ACLDAO.instance().delete(g.getDefaultACL());
            }
            throw e;
        }
    }

    protected ACLEntry[] getACLImpl(String container, boolean defaultACL) throws VOMSException {
        ACL acl = (ACL)LoadACLOperation.instance(container, defaultACL).execute();
        return ServiceUtils.toACLEntryArray(acl);
    }

    public ACLEntry[] getACL(String container) throws RemoteException, VOMSException {
        log.info((Object)("getACL(" + container + ");"));
        if (container == null) {
            throw new NullArgumentException("container cannot be null!");
        }
        try {
            ACLEntry[] retVal = this.getACLImpl(container, false);
            HibernateFactory.commitTransaction();
            return retVal;
        }
        catch (RuntimeException e) {
            log.error((Object)e);
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    public ACLEntry[] getDefaultACL(String container) throws RemoteException, VOMSException {
        log.info((Object)("getDefaultACL(" + container + ");"));
        if (container == null) {
            throw new NullArgumentException("container cannot be null!");
        }
        try {
            ACLEntry[] retVal = this.getACLImpl(container, true);
            HibernateFactory.commitTransaction();
            return retVal;
        }
        catch (RuntimeException e) {
            log.error((Object)e);
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    public void removeACLEntry(String container, ACLEntry entry, boolean removeFromChildrenContexts) throws RemoteException, VOMSException {
        log.info((Object)("removeACLEntry(" + StringUtils.join((Object[])new Object[]{container, entry, removeFromChildrenContexts}, (char)',') + ");"));
        if (container == null) {
            throw new NullArgumentException("container cannot be null!");
        }
        if (entry == null) {
            throw new NullArgumentException("entry cannot be null!");
        }
        try {
            ACL theACL = (ACL)LoadACLOperation.instance(container).execute();
            VOMSAdmin admin = this.getAdminFromEntry(entry);
            DeleteACLEntryOperation.instance(theACL, admin, removeFromChildrenContexts).execute();
            HibernateFactory.commitTransaction();
        }
        catch (RuntimeException e) {
            log.error((Object)e);
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    public void removeDefaultACLEntry(String group, ACLEntry entry) throws RemoteException, VOMSException {
        log.info((Object)("removeDefaultACLEntry(" + StringUtils.join((Object[])new Object[]{group, entry}, (char)',') + ");"));
        if (group == null) {
            throw new NullArgumentException("group cannot be null!");
        }
        if (entry == null) {
            throw new NullArgumentException("entry cannot be null!");
        }
        try {
            ACL theACL = (ACL)LoadACLOperation.instance(group, true).execute();
            if (theACL == null) {
                throw new NoSuchACLException("Default ACL is not defined for group " + group);
            }
            VOMSAdmin admin = this.getAdminFromEntry(entry);
            DeleteACLEntryOperation.instance(theACL, admin).execute();
            HibernateFactory.commitTransaction();
        }
        catch (RuntimeException e) {
            log.error((Object)e);
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    protected void setACLImpl(String container, boolean defaultACL, ACLEntry[] entries) throws VOMSException {
        if (container == null) {
            throw new NullArgumentException("container cannot be null!");
        }
        if (entries == null) {
            throw new NullArgumentException("entries cannot be null!");
        }
        VOMSGroup g = null;
        try {
            ACL theACL = (ACL)LoadACLOperation.instance(container, defaultACL).execute();
            if (theACL == null && defaultACL) {
                g = VOMSGroupDAO.instance().findByName(container);
                theACL = ACLDAO.instance().create(g, true);
            }
            SetACLOperation.instance(theACL, ServiceUtils.toPermissionMap(entries)).execute();
            HibernateFactory.commitTransaction();
        }
        catch (RuntimeException e) {
            log.error((Object)e);
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (g != null && g.getDefaultACL() != null && g.getDefaultACL().getPermissions().isEmpty()) {
                ACLDAO.instance().delete(g.getDefaultACL());
            }
            throw e;
        }
    }

    public void setACL(String container, ACLEntry[] entries) throws RemoteException, VOMSException {
        log.info((Object)("setACL(" + StringUtils.join((Object[])new Object[]{container, entries}, (char)',') + ");"));
        this.setACLImpl(container, false, entries);
    }

    public void setDefaultACL(String group, ACLEntry[] entries) throws RemoteException, VOMSException {
        log.info((Object)("setDefaultACL(" + StringUtils.join((Object[])new Object[]{group, entries}, (char)',') + ");"));
        this.setACLImpl(group, true, entries);
    }

    protected VOMSAdmin getAdminFromEntry(ACLEntry entry) {
        if (entry.getAdminSubject() == null) {
            throw new NullArgumentException("entry.adminSubject cannot be null!");
        }
        if (entry.getAdminIssuer() == null) {
            throw new NullArgumentException("entry.adminIssuer cannot be null!");
        }
        String subject = entry.getAdminSubject();
        String issuer = entry.getAdminIssuer();
        VOMSAdmin admin = VOMSAdminDAO.instance().getByName(subject, issuer);
        if (admin == null) {
            if (issuer.equals("/O=VOMS/O=System/CN=Dummy Certificate Authority")) {
                return VOMSAdminDAO.instance().getAnyAuthenticatedUserAdmin();
            }
            if (issuer.equals("/O=VOMS/O=System/CN=VOMS Group")) {
                VOMSGroup g = VOMSGroupDAO.instance().findByName(subject);
                if (g == null) {
                    throw new NoSuchGroupException("Group '" + subject + "' is not defined in database!");
                }
                return VOMSAdminDAO.instance().create(subject);
            }
            if (issuer.equals("/O=VOMS/O=System/CN=VOMS Role")) {
                String groupName = PathNamingScheme.getGroupName(subject);
                String roleName = PathNamingScheme.getRoleName(subject);
                VOMSGroup g = VOMSGroupDAO.instance().findByName(groupName);
                VOMSRole r = VOMSRoleDAO.instance().findByName(roleName);
                if (g == null) {
                    throw new NoSuchGroupException("Group '" + groupName + "' is not defined in database!");
                }
                if (r == null) {
                    throw new NoSuchRoleException("Role '" + roleName + "' is not defined in database!");
                }
                return VOMSAdminDAO.instance().create(subject);
            }
            return VOMSAdminDAO.instance().create(subject, issuer);
        }
        return admin;
    }
}

