/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.service;

import java.rmi.RemoteException;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.ACLEntry;
import org.glite.security.voms.User;
import org.glite.security.voms.VOMSException;
import org.glite.security.voms.admin.common.NullArgumentException;
import org.glite.security.voms.admin.common.PathNamingScheme;
import org.glite.security.voms.admin.common.UnimplementedFeatureException;
import org.glite.security.voms.admin.common.VOMSConfiguration;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.glite.security.voms.admin.database.NoSuchUserException;
import org.glite.security.voms.admin.model.VOMSUser;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.ca.ListCaOperation;
import org.glite.security.voms.admin.operations.groups.AddMemberOperation;
import org.glite.security.voms.admin.operations.groups.CreateGroupOperation;
import org.glite.security.voms.admin.operations.groups.DeleteGroupOperation;
import org.glite.security.voms.admin.operations.groups.ListChildrenGroupsOperation;
import org.glite.security.voms.admin.operations.groups.ListMembersOperation;
import org.glite.security.voms.admin.operations.groups.RemoveMemberOperation;
import org.glite.security.voms.admin.operations.roles.CreateRoleOperation;
import org.glite.security.voms.admin.operations.roles.DeleteRoleOperation;
import org.glite.security.voms.admin.operations.roles.ListRolesOperation;
import org.glite.security.voms.admin.operations.users.AssignRoleOperation;
import org.glite.security.voms.admin.operations.users.CreateUserOperation;
import org.glite.security.voms.admin.operations.users.DeleteUserOperation;
import org.glite.security.voms.admin.operations.users.DismissRoleOperation;
import org.glite.security.voms.admin.operations.users.FindUserOperation;
import org.glite.security.voms.admin.operations.users.ListUserGroupsOperation;
import org.glite.security.voms.admin.operations.users.ListUserRolesOperation;
import org.glite.security.voms.admin.operations.users.UpdateUserOperation;
import org.glite.security.voms.admin.service.ServiceExceptionHelper;
import org.glite.security.voms.admin.service.ServiceUtils;
import org.glite.security.voms.admin.service.Validator;
import org.glite.security.voms.service.admin.VOMSAdmin;

public class VomsAdminService
implements VOMSAdmin {
    private static final Log log = LogFactory.getLog(VomsAdminService.class);

    public User getUser(String username, String userca) throws RemoteException, VOMSException {
        log.info((Object)("getUser(" + StringUtils.join((Object[])new Object[]{username, userca}, (char)',') + ");"));
        try {
            VOMSUser u = (VOMSUser)FindUserOperation.instance(username, userca).execute();
            if (u == null) {
                return null;
            }
            return u.asUser();
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public void setUser(User user) throws RemoteException, VOMSException {
        log.info((Object)("setUser(" + StringUtils.join((Object[])new Object[]{user}, (char)',') + ");"));
        if (user == null) {
            throw new NullArgumentException("User passed as argument is null!");
        }
        VOMSUser u = (VOMSUser)FindUserOperation.instance(user.getDN(), user.getCA()).execute();
        if (u == null) {
            throw new NoSuchUserException("User (" + user.getDN() + "," + user.getCA() + ") not found in database!");
        }
        Validator.validateUser(user);
        u.fromUser(user);
        UpdateUserOperation.instance(u).execute();
    }

    public void createGroup(String parentname, String groupname) throws RemoteException, VOMSException {
        log.info((Object)("createGroup(" + StringUtils.join((Object[])new Object[]{parentname, groupname}, (char)',') + ");"));
        if (!groupname.startsWith("/")) {
            groupname = "/" + groupname;
        }
        try {
            Validator.validateInputString(groupname, "Invalid characters in group name!");
            CreateGroupOperation.instance(groupname).execute();
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public int getMajorVersionNumber() throws RemoteException {
        log.info((Object)("getMajorVersionNumber(" + StringUtils.join((Object[])new Object[0], (char)',') + ");"));
        return 2;
    }

    public String getVOName() throws RemoteException, VOMSException {
        log.info((Object)("getVOName(" + StringUtils.join((Object[])new Object[0], (char)',') + ");"));
        try {
            return "/" + VOMSConfiguration.instance().getVOName();
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public void createUser(User user) throws RemoteException, VOMSException {
        log.info((Object)("createUser(" + StringUtils.join((Object[])new Object[]{user.getDN(), user.getCA()}, (char)',') + ");"));
        try {
            Validator.validateUser(user);
            CreateUserOperation.instance(user.getDN(), user.getCA(), user.getCN(), user.getCertUri(), user.getMail()).execute();
            HibernateFactory.commitTransaction();
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public void deleteUser(String username, String userca) throws RemoteException, VOMSException {
        log.info((Object)("deleteUser(" + StringUtils.join((Object[])new Object[]{username, userca}, (char)',') + ");"));
        try {
            DeleteUserOperation.instance(username, userca).execute();
            HibernateFactory.commitTransaction();
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public void deleteGroup(String groupname) throws RemoteException, VOMSException {
        log.info((Object)("deleteGroup(" + StringUtils.join((Object[])new Object[]{groupname}, (char)',') + ");"));
        try {
            if (!groupname.startsWith("/")) {
                groupname = "/" + groupname;
            }
            DeleteGroupOperation.instance(groupname).execute();
            HibernateFactory.commitTransaction();
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public void createRole(String rolename) throws RemoteException, VOMSException {
        log.info((Object)("createRole(" + StringUtils.join((Object[])new Object[]{rolename}, (char)',') + ");"));
        try {
            Validator.validateDN(rolename, "Invalid characters in role name!");
            if (PathNamingScheme.isRole(rolename)) {
                rolename = PathNamingScheme.getRoleName(rolename);
            }
            CreateRoleOperation.instance(rolename).execute();
            HibernateFactory.commitTransaction();
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public void deleteRole(String rolename) throws RemoteException, VOMSException {
        log.info((Object)("deleteRole(" + StringUtils.join((Object[])new Object[]{rolename}, (char)',') + ");"));
        try {
            if (PathNamingScheme.isRole(rolename)) {
                rolename = PathNamingScheme.getRoleName(rolename);
            }
            DeleteRoleOperation.instance(rolename).execute();
            HibernateFactory.commitTransaction();
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public void createCapability(String capability) throws RemoteException, VOMSException {
        log.info((Object)("createCapability(" + StringUtils.join((Object[])new Object[]{capability}, (char)',') + ");"));
        try {
            throw new UnimplementedFeatureException("createCapability(String s)");
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public void deleteCapability(String capability) throws RemoteException, VOMSException {
        log.info((Object)("deleteCapability(" + StringUtils.join((Object[])new Object[]{capability}, (char)',') + ");"));
        throw new UnimplementedFeatureException("deleteCapability(String s)");
    }

    public void addMember(String groupname, String username, String userca) throws RemoteException, VOMSException {
        log.info((Object)("addMember(" + StringUtils.join((Object[])new Object[]{groupname, username, userca}, (char)',') + ");"));
        try {
            AddMemberOperation.instance(groupname, username, userca).execute();
            HibernateFactory.commitTransaction();
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public void removeMember(String groupname, String username, String userca) throws RemoteException, VOMSException {
        log.info((Object)("removeMember(" + StringUtils.join((Object[])new Object[]{groupname, username, userca}, (char)',') + ");"));
        try {
            RemoveMemberOperation.instance(groupname, username, userca).execute();
            HibernateFactory.commitTransaction();
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public void assignRole(String groupname, String rolename, String username, String userca) throws RemoteException, VOMSException {
        log.info((Object)("assignRole(" + StringUtils.join((Object[])new Object[]{groupname, rolename, username, userca}, (char)',') + ");"));
        if (PathNamingScheme.isRole(rolename)) {
            rolename = PathNamingScheme.getRoleName(rolename);
        }
        try {
            AssignRoleOperation.instance(groupname, rolename, username, userca).execute();
            HibernateFactory.commitTransaction();
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public void dismissRole(String groupname, String rolename, String username, String userca) throws RemoteException, VOMSException {
        log.info((Object)("dismissRole(" + StringUtils.join((Object[])new Object[]{groupname, rolename, username, userca}, (char)',') + ");"));
        if (PathNamingScheme.isRole(rolename)) {
            rolename = PathNamingScheme.getRoleName(rolename);
        }
        try {
            DismissRoleOperation.instance(groupname, rolename, username, userca).execute();
            HibernateFactory.commitTransaction();
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public void assignCapability(String capability, String username, String userca) throws RemoteException, VOMSException {
        log.info((Object)("assignCapability(" + StringUtils.join((Object[])new Object[]{capability, username, userca}, (char)',') + ");"));
        throw new UnimplementedFeatureException("assignCapability(...)");
    }

    public void dismissCapability(String capability, String username, String userca) throws RemoteException, VOMSException {
        log.info((Object)("dismissCapability(" + StringUtils.join((Object[])new Object[]{capability, username, userca}, (char)',') + ");"));
        throw new UnimplementedFeatureException("dismissCapability(...)");
    }

    public User[] listMembers(String groupname) throws RemoteException, VOMSException {
        log.info((Object)("listMembers(" + StringUtils.join((Object[])new Object[]{groupname}, (char)',') + ");"));
        if (groupname == null || groupname.equals("")) {
            groupname = "/" + VOMSConfiguration.instance().getVOName();
        }
        try {
            List members = (List)ListMembersOperation.instance(groupname).execute();
            HibernateFactory.commitTransaction();
            return VOMSUser.collectionAsUsers(members);
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public User[] listUsersWithRole(String groupname, String rolename) throws RemoteException, VOMSException {
        log.info((Object)("listUsersWithRole(" + StringUtils.join((Object[])new Object[]{groupname, rolename}, (char)',') + ");"));
        try {
            if (!PathNamingScheme.isRole(rolename)) {
                rolename = "Role=" + rolename;
            }
            String contextString = groupname + "/" + rolename;
            List members = (List)ListMembersOperation.instance(contextString).execute();
            HibernateFactory.commitTransaction();
            return VOMSUser.collectionAsUsers(members);
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public User[] listUsersWithCapability(String capability) throws RemoteException, VOMSException {
        log.info((Object)("listUsersWithCapability(" + StringUtils.join((Object[])new Object[]{capability}, (char)',') + ");"));
        throw new UnimplementedFeatureException("listUsersWithCapability(...)");
    }

    public String[] getGroupPath(String groupname) throws RemoteException, VOMSException {
        log.info((Object)("getGroupPath(" + StringUtils.join((Object[])new Object[]{groupname}, (char)',') + ");"));
        try {
            String[] parentChain = PathNamingScheme.getParentGroupChain(groupname);
            String[] result = new String[parentChain.length + 1];
            result[0] = groupname;
            System.arraycopy(parentChain, 0, result, 1, parentChain.length);
            return result;
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public String[] listSubGroups(String groupname) throws RemoteException, VOMSException {
        log.info((Object)("listSubGroups(" + StringUtils.join((Object[])new Object[]{groupname}, (char)',') + ");"));
        try {
            List childrenGroups;
            if (groupname == null) {
                VOMSContext ctxt = VOMSContext.getVoContext();
                childrenGroups = (List)ListChildrenGroupsOperation.instance(ctxt.getGroup()).execute();
            } else {
                childrenGroups = (List)ListChildrenGroupsOperation.instance(groupname).execute();
            }
            HibernateFactory.commitTransaction();
            return ServiceUtils.groupsToStringArray(childrenGroups);
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public String[] listGroups(String username, String userca) throws RemoteException, VOMSException {
        log.info((Object)("listGroups(" + StringUtils.join((Object[])new Object[]{username, userca}, (char)',') + ");"));
        try {
            Set groups = (Set)ListUserGroupsOperation.instance(username, userca).execute();
            HibernateFactory.commitTransaction();
            return ServiceUtils.groupsToStringArray(groups);
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public String[] listRoles(String username, String userca) throws RemoteException, VOMSException {
        log.info((Object)("listRoles(" + StringUtils.join((Object[])new Object[]{username, userca}, (char)',') + ");"));
        try {
            Set roles = (Set)ListUserRolesOperation.instance(username, userca).execute();
            HibernateFactory.commitTransaction();
            return ServiceUtils.toStringArray(roles);
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public String[] listRoles() throws RemoteException, VOMSException {
        log.info((Object)"listRoles();");
        try {
            List roles = (List)ListRolesOperation.instance().execute();
            HibernateFactory.commitTransaction();
            return ServiceUtils.rolesToStringArray(roles);
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public String[] listCapabilities(String username, String userca) throws RemoteException, VOMSException {
        log.info((Object)("listCapabilities(" + StringUtils.join((Object[])new Object[]{username, userca}, (char)',') + ");"));
        throw new UnimplementedFeatureException("listCapabilities(...)");
    }

    public String[] listCapabilities() throws RemoteException, VOMSException {
        log.info((Object)("listCapabilities(" + StringUtils.join((Object[])new Object[0], (char)',') + ");"));
        throw new UnimplementedFeatureException("listCapabilities(...)");
    }

    public String[] listCAs() throws RemoteException, VOMSException {
        log.info((Object)"listCAs();");
        try {
            List cas = (List)ListCaOperation.instance().execute();
            HibernateFactory.commitTransaction();
            return ServiceUtils.casToStringArray(cas);
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public ACLEntry[] getACL(String container) throws RemoteException, VOMSException {
        log.info((Object)("getACL(" + StringUtils.join((Object[])new Object[]{container}, (char)',') + ");"));
        throw new UnimplementedFeatureException("getACL(...)");
    }

    public void setACL(String container, ACLEntry[] acl) throws RemoteException, VOMSException {
        log.info((Object)("setACL(" + StringUtils.join((Object[])new Object[]{container, acl}, (char)',') + ");"));
        throw new UnimplementedFeatureException("setACL(...)");
    }

    public void addACLEntry(String container, ACLEntry aclEntry) throws RemoteException, VOMSException {
        log.info((Object)("addACLEntry(" + StringUtils.join((Object[])new Object[]{container, aclEntry}, (char)',') + ");"));
        throw new UnimplementedFeatureException("addACLEntry(...)");
    }

    public void removeACLEntry(String container, ACLEntry aclEntry) throws RemoteException, VOMSException {
        log.info((Object)("removeACLEntry(" + StringUtils.join((Object[])new Object[]{container, aclEntry}, (char)',') + ");"));
        throw new UnimplementedFeatureException("removeACLEntry(...)");
    }

    public ACLEntry[] getDefaultACL(String groupname) throws RemoteException, VOMSException {
        log.info((Object)("getDefaultACL(" + StringUtils.join((Object[])new Object[]{groupname}, (char)',') + ");"));
        throw new UnimplementedFeatureException("getDefaultACL(...)");
    }

    public void setDefaultACL(String groupname, ACLEntry[] aclEntry) throws RemoteException, VOMSException {
        log.info((Object)("setDefaultACL(" + StringUtils.join((Object[])new Object[]{groupname, aclEntry}, (char)',') + ");"));
        throw new UnimplementedFeatureException("setDefaultACL(...)");
    }

    public void addDefaultACLEntry(String groupname, ACLEntry aclEntry) throws RemoteException, VOMSException {
        log.info((Object)("addDefaultACLEntry(" + StringUtils.join((Object[])new Object[]{groupname, aclEntry}, (char)',') + ");"));
        throw new UnimplementedFeatureException("addDefaultACLEntry(...)");
    }

    public void removeDefaultACLEntry(String groupname, ACLEntry aclEntry) throws RemoteException, VOMSException {
        log.info((Object)("removeDefaultACLEntry(" + StringUtils.join((Object[])new Object[]{groupname, aclEntry}, (char)',') + ");"));
        throw new UnimplementedFeatureException("removeDefaultACLEntry(...)");
    }

    public int getMinorVersionNumber() throws RemoteException {
        log.info((Object)"getMinorVersionNumber()");
        return 0;
    }

    public int getPatchVersionNumber() throws RemoteException {
        log.info((Object)"getPatchVersionNumber()");
        return 0;
    }
}

