/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.service;

import java.rmi.RemoteException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.voms.VOMSException;
import org.glite.security.voms.admin.common.VOMSConfiguration;
import org.glite.security.voms.admin.operations.groups.ListMemberNamesOperation;
import org.glite.security.voms.admin.service.ServiceExceptionHelper;
import org.glite.security.voms.admin.service.ServiceUtils;
import org.glite.security.voms.service.compatibility.VOMSCompatibility;

public class VomsCompatibilityService
implements VOMSCompatibility {
    private static final Log log = LogFactory.getLog(VomsCompatibilityService.class);

    public int getMajorVersionNumber() throws RemoteException {
        return 2;
    }

    public int getMinorVersionNumber() throws RemoteException {
        return 0;
    }

    public int getPatchVersionNumber() throws RemoteException {
        return 0;
    }

    public String[] getGridmapUsers() throws RemoteException, VOMSException {
        log.info((Object)"getGridmapUsers();");
        try {
            String voName = VOMSConfiguration.instance().getVOName();
            List<String> members = (List<String>)ListMemberNamesOperation.instance("/" + voName).execute();
            if (VOMSConfiguration.instance().getBoolean("voms.mkgridmap.translate_dn_email_format", false)) {
                members = ServiceUtils.decorateDNList(members);
            }
            return ServiceUtils.toStringArray(members);
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    public String[] getGridmapUsers(String container) throws RemoteException, VOMSException {
        log.info((Object)("getGridmapUsers(" + container + ");"));
        try {
            List<String> members = (List<String>)ListMemberNamesOperation.instance(container).execute();
            if (VOMSConfiguration.instance().getBoolean("voms.mkgridmap.translate_dn_email_format", false)) {
                members = ServiceUtils.decorateDNList(members);
            }
            return ServiceUtils.toStringArray(members);
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }
}

