/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.test;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.glite.security.voms.admin.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.database.AlreadyExistsException;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.glite.security.voms.admin.database.IllegalOperationException;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.test.DatabaseInitializer;

public class TestGroupOperations
extends TestCase {
    private static final Log log = LogFactory.getLog(TestGroupOperations.class);

    public TestGroupOperations() {
        PropertyConfigurator.configure((String)"./src/log4j.test.properties");
        DatabaseInitializer.initialize();
    }

    protected void tearDown() throws Exception {
        VOMSGroupDAO.instance().deleteAll();
        HibernateFactory.commitTransaction();
    }

    public void testGroupCreation() {
        VOMSGroup g1 = VOMSGroupDAO.instance().create("/org.glite.security.voms.admin.test/g1");
        TestGroupOperations.assertNotNull((Object)g1);
        try {
            VOMSGroupDAO.instance().create("/org.glite.security.voms.admin.test/g1");
        }
        catch (AlreadyExistsException e) {
            return;
        }
        throw new AssertionFailedError("Double creation of the same group didn't raise an error!");
    }

    public void testGroupDeletion() {
        VOMSGroup g1 = VOMSGroupDAO.instance().create("/org.glite.security.voms.admin.test/g1");
        TestGroupOperations.assertNotNull((Object)g1);
        VOMSGroupDAO.instance().delete(g1);
        g1 = VOMSGroupDAO.instance().findByName("/org.glite.security.voms.admin.test/g1");
        TestGroupOperations.assertNull((Object)g1);
    }

    public void testRootGroupDeletion() {
        VOMSGroup voGroup = VOMSGroupDAO.instance().getVOGroup();
        try {
            VOMSGroupDAO.instance().delete(voGroup);
        }
        catch (IllegalOperationException ex) {
            return;
        }
        throw new AssertionFailedError("Removal of root group didn't raise an error!");
    }

    public void testRecursiveGroupDeletion() {
        VOMSGroupDAO dao = VOMSGroupDAO.instance();
        VOMSGroup g1 = dao.create("/org.glite.security.voms.admin.test/g1");
        TestGroupOperations.assertNotNull((Object)g1);
        VOMSGroup g2 = dao.create("/org.glite.security.voms.admin.test/g1/g2");
        try {
            dao.delete(g1);
        }
        catch (IllegalOperationException ex) {
            return;
        }
        throw new AssertionFailedError("Deletion of non-empty group didn't raise an error!");
    }
}

