/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.test;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.glite.security.voms.admin.common.VOMSConfiguration;
import org.glite.security.voms.admin.common.VOMSException;
import org.glite.security.voms.admin.dao.VOMSUserDAO;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.glite.security.voms.admin.model.VOMSUser;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;

public class TestMain {
    public static final Log log = LogFactory.getLog(TestMain.class);
    private static final String hibernatePropertiesFile = "debug/pc/etc/voms-admin/test_vo/voms.database.properties";
    private static final String vo = "test_vo";

    private Configuration loadHibernateConfiguration() {
        Properties dbProperties = new Properties();
        try {
            if (hibernatePropertiesFile == null) {
                String f = System.getProperty("GLITE_LOCATION_VAR") + "/etc/voms-admin/" + vo + "/voms.database.properties";
                log.debug((Object)("Loading database properties from: " + f));
                dbProperties.load(new FileInputStream(f));
            } else {
                dbProperties.load(new FileInputStream(hibernatePropertiesFile));
            }
        }
        catch (IOException e) {
            log.error((Object)("Error loading hibernate properties: " + e.getMessage()), (Throwable)e);
            throw new VOMSException("Error loading hibernate properties: " + e.getMessage(), e);
        }
        return new Configuration().addProperties(dbProperties).configure();
    }

    public TestMain() {
        VOMSConfiguration.instance(false, null);
        Session s = HibernateFactory.getSession();
        String ca = "/C=IT/O=INFN/CN=INFN CA";
        VOMSUser u = VOMSUserDAO.instance().findByName("ciccio", ca);
        VOMSUserDAO.instance().setAttribute(u, "a", "2331");
        HibernateFactory.commitTransaction();
    }

    public static void main(String[] args) {
        PropertyConfigurator.configure((String)"./src/webapp/WEB-INF/classes/log4j.properties");
        System.setProperty("GLITE_LOCATION", System.getenv("GLITE_LOCATION"));
        System.setProperty("GLITE_LOCATION_VAR", System.getenv("GLITE_LOCATION_VAR"));
        System.setProperty("voms.vo.name", "test_vo_mysql");
        new TestMain();
    }
}

