/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.test;

import junit.framework.TestCase;
import org.apache.log4j.PropertyConfigurator;
import org.glite.security.voms.admin.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.dao.VOMSUserDAO;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSRole;
import org.glite.security.voms.admin.model.VOMSUser;
import org.glite.security.voms.admin.test.DatabaseInitializer;

public class TestMassiveUserOperation
extends TestCase {
    private static final String eAddr = "org.glite.security.voms.admin.test@org.glite.security.voms.admin.test";
    private final VOMSGroup voGroup;

    public TestMassiveUserOperation() {
        PropertyConfigurator.configure((String)"./src/log4j.test.properties");
        DatabaseInitializer.initialize();
        this.voGroup = VOMSGroupDAO.instance().getVOGroup();
    }

    public void testMassiveUserCreationDeletion() {
        int i;
        int NUM_USERS = 100;
        VOMSUser[] users = new VOMSUser[100];
        for (i = 0; i < 100; ++i) {
            users[i] = VOMSUserDAO.instance().create("user_" + i, "/O=VOMS/O=System/CN=Dummy Certificate Authority", null, null, "user_" + i);
            TestMassiveUserOperation.assertTrue((boolean)users[i].isMember(this.voGroup));
        }
        HibernateFactory.commitTransaction();
        for (i = 0; i < 100; ++i) {
            TestMassiveUserOperation.assertTrue((boolean)users[i].isMember(this.voGroup));
            VOMSUserDAO.instance().delete(users[i]);
        }
    }

    public void testMassiveUserAdds() {
        int i;
        int NUM_GROUPS = 30;
        int NUM_USERS = 30;
        VOMSGroup[] groups = new VOMSGroup[30];
        VOMSUser[] users = new VOMSUser[30];
        for (i = 0; i < 30; ++i) {
            groups[i] = VOMSGroupDAO.instance().create(this.voGroup.getName() + "/" + "g" + i);
        }
        for (i = 0; i < 30; ++i) {
            users[i] = VOMSUserDAO.instance().create("user_" + i, "/O=VOMS/O=System/CN=Dummy Certificate Authority", null, null, "user_" + i);
            TestMassiveUserOperation.assertTrue((boolean)users[i].isMember(this.voGroup));
            for (int j = 0; j < 30; ++j) {
                VOMSUserDAO.instance().addToGroup(users[i], groups[j]);
                TestMassiveUserOperation.assertTrue((boolean)users[i].isMember(groups[j]));
            }
        }
        HibernateFactory.commitTransaction();
        for (i = 0; i < 30; ++i) {
            VOMSGroupDAO.instance().delete(groups[i]);
        }
        for (i = 0; i < 30; ++i) {
            VOMSUserDAO.instance().delete(users[i]);
        }
        HibernateFactory.commitTransaction();
    }

    public void testMassiveMembership() {
        int j;
        int i;
        int NUM_GROUPS = 20;
        int NUM_ROLES = 20;
        VOMSUser u1 = VOMSUserDAO.instance().create("U1", "/O=VOMS/O=System/CN=Dummy Certificate Authority", null, null, eAddr);
        TestMassiveUserOperation.assertNotNull((String)"VOMSUserDAO.createUser returned a null VOMSUser!", (Object)u1);
        TestMassiveUserOperation.assertTrue((String)"Just created user is not a member of the vo root group", (boolean)u1.isMember(VOMSGroupDAO.instance().getVOGroup()));
        VOMSRole[] roles = new VOMSRole[20];
        for (int i2 = 0; i2 < 20; ++i2) {
            roles[i2] = VOMSRoleDAO.instance().create("R" + i2);
        }
        HibernateFactory.commitTransaction();
        VOMSGroup[] groups = new VOMSGroup[20];
        for (i = 0; i < 20; ++i) {
            groups[i] = i > 0 ? VOMSGroupDAO.instance().create(groups[i - 1].getName() + "/" + "group" + i) : VOMSGroupDAO.instance().create("/org.glite.security.voms.admin.test/group" + i);
            VOMSUserDAO.instance().addToGroup(u1, groups[i]);
            for (j = 0; j < 20; ++j) {
                VOMSUserDAO.instance().assignRole(u1, groups[i], roles[j]);
            }
        }
        HibernateFactory.commitTransaction();
        for (i = 0; i < 20; ++i) {
            TestMassiveUserOperation.assertTrue((boolean)u1.isMember(groups[i]));
            for (j = 0; j < 20; ++j) {
                TestMassiveUserOperation.assertTrue((boolean)u1.hasRole(groups[i], roles[j]));
            }
        }
        VOMSUserDAO.instance().delete(u1);
        HibernateFactory.commitTransaction();
    }
}

