/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.test;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.log4j.PropertyConfigurator;
import org.glite.security.voms.admin.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.database.AlreadyExistsException;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.glite.security.voms.admin.database.NoSuchAttributeException;
import org.glite.security.voms.admin.database.NoSuchRoleException;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSRole;
import org.glite.security.voms.admin.model.VOMSRoleAttribute;
import org.glite.security.voms.admin.test.DatabaseInitializer;

public class TestRoleOperations
extends TestCase {
    public TestRoleOperations() {
        PropertyConfigurator.configure((String)"./src/log4j.test.properties");
        DatabaseInitializer.initialize();
    }

    protected void tearDown() throws Exception {
        HibernateFactory.commitTransaction();
    }

    public void testRoleCreation() {
        VOMSRole r1 = VOMSRoleDAO.instance().create("r1");
        VOMSRole r2 = VOMSRoleDAO.instance().create("r2");
        TestRoleOperations.assertNotNull((Object)"r1");
        TestRoleOperations.assertNotNull((Object)"r2");
        TestRoleOperations.assertNotSame((Object)r1, (Object)r2);
        try {
            VOMSRoleDAO.instance().create("r1");
        }
        catch (AlreadyExistsException ex) {
            return;
        }
        throw new AssertionFailedError("Double creation of the same role didn't raise an error!");
    }

    public void testRoleDeletion() {
        VOMSRole r1 = VOMSRoleDAO.instance().findByName("r1");
        VOMSRole r2 = VOMSRoleDAO.instance().findByName("r2");
        TestRoleOperations.assertNotNull((Object)"r1");
        TestRoleOperations.assertNotNull((Object)"r2");
        TestRoleOperations.assertNotSame((Object)r1, (Object)r2);
        VOMSRoleDAO.instance().delete(r1);
        TestRoleOperations.assertNull((Object)VOMSRoleDAO.instance().findByName("r1"));
        try {
            VOMSRoleDAO.instance().delete(r1);
        }
        catch (NoSuchRoleException ex) {
            return;
        }
        throw new AssertionFailedError("Double deletion of the same role didn't raise an error!");
    }

    public void testAttributeCreation() {
        VOMSRole r1 = VOMSRoleDAO.instance().create("r1");
        VOMSRole r2 = VOMSRoleDAO.instance().findByName("r2");
        VOMSGroup g1 = VOMSGroupDAO.instance().create("/org.glite.security.voms.admin.test/g1");
        VOMSGroup voGroup = VOMSGroupDAO.instance().getVOGroup();
        TestRoleOperations.assertNotNull((Object)"r1");
        TestRoleOperations.assertNotNull((Object)"r2");
        TestRoleOperations.assertNotSame((Object)r1, (Object)r2);
        VOMSRoleAttribute g1Val = VOMSRoleDAO.instance().createAttribute(r1, g1, "org.glite.security.voms.admin.test", null, null);
        VOMSRoleAttribute g2Val = VOMSRoleDAO.instance().createAttribute(r1, voGroup, "org.glite.security.voms.admin.test", null, "v");
        TestRoleOperations.assertNotNull((Object)g1Val);
        TestRoleOperations.assertEquals((String)g1Val.getName(), (String)"org.glite.security.voms.admin.test");
        TestRoleOperations.assertEquals((Object)g1Val.getGroup(), (Object)g1);
        TestRoleOperations.assertNull((Object)g1Val.getValue());
        TestRoleOperations.assertNotNull((Object)g2Val);
        TestRoleOperations.assertEquals((String)g2Val.getName(), (String)"org.glite.security.voms.admin.test");
        TestRoleOperations.assertEquals((Object)g2Val.getGroup(), (Object)voGroup);
        TestRoleOperations.assertEquals((String)g2Val.getValue(), (String)"v");
    }

    public void testAttributeDeletion() {
        VOMSRole r1 = VOMSRoleDAO.instance().findByName("r1");
        VOMSGroup g1 = VOMSGroupDAO.instance().findByName("/org.glite.security.voms.admin.test/g1");
        VOMSGroup voGroup = VOMSGroupDAO.instance().getVOGroup();
        VOMSRoleAttribute g1Val = r1.getAttributeByName(g1, "org.glite.security.voms.admin.test");
        TestRoleOperations.assertNotNull((Object)g1Val);
        TestRoleOperations.assertEquals((String)g1Val.getName(), (String)"org.glite.security.voms.admin.test");
        TestRoleOperations.assertEquals((Object)g1Val.getGroup(), (Object)g1);
        TestRoleOperations.assertNull((Object)g1Val.getValue());
        VOMSRoleDAO.instance().deleteAttribute(r1, g1Val);
        TestRoleOperations.assertNull((Object)r1.getAttributeByName(g1, "org.glite.security.voms.admin.test"));
        VOMSRoleAttribute voGroupVal = r1.getAttributeByName(voGroup, "org.glite.security.voms.admin.test");
        TestRoleOperations.assertNotNull((Object)voGroupVal);
        boolean gotException = false;
        try {
            VOMSRoleDAO.instance().deleteAttribute(r1, g1Val);
        }
        catch (NoSuchAttributeException e) {
            gotException = true;
        }
        if (!gotException) {
            throw new AssertionFailedError("Double deletion of the same role attribute didn't raise an error!");
        }
        VOMSRoleDAO.instance().deleteAttribute(r1, voGroupVal);
        TestRoleOperations.assertNull((Object)r1.getAttributeByName(voGroup, "org.glite.security.voms.admin.test"));
    }
}

