/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.test;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.log4j.PropertyConfigurator;
import org.glite.security.voms.admin.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.dao.VOMSUserDAO;
import org.glite.security.voms.admin.database.AlreadyExistsException;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.glite.security.voms.admin.database.NoSuchUserException;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSRole;
import org.glite.security.voms.admin.model.VOMSUser;
import org.glite.security.voms.admin.test.DatabaseInitializer;

public class TestUserOperations
extends TestCase {
    private static final String eAddr = "org.glite.security.voms.admin.test@org.glite.security.voms.admin.test";

    public TestUserOperations() {
        PropertyConfigurator.configure((String)"./src/log4j.test.properties");
        DatabaseInitializer.initialize();
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
        HibernateFactory.commitTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserCreation() {
        VOMSUser u1 = VOMSUserDAO.instance().create("U1", "/O=VOMS/O=System/CN=Dummy Certificate Authority", null, null, eAddr);
        TestUserOperations.assertNotNull((String)"VOMSUserDAO.createUser returned a null VOMSUser!", (Object)u1);
        TestUserOperations.assertTrue((String)"Just created user is not a member of the vo root group", (boolean)u1.isMember(VOMSGroupDAO.instance().getVOGroup()));
        try {
            VOMSUserDAO.instance().create("U1", "/O=VOMS/O=System/CN=Dummy Certificate Authority", null, null, eAddr);
        }
        catch (AlreadyExistsException ex) {
            return;
        }
        finally {
            HibernateFactory.commitTransaction();
        }
        throw new AssertionFailedError("Double creation of the same user didn't raise an error!");
    }

    public void testUserDeletion() {
        VOMSUser u1 = VOMSUserDAO.instance().getByName("U1", "/O=VOMS/O=System/CN=Dummy Certificate Authority");
        TestUserOperations.assertNotNull((Object)u1);
        VOMSUserDAO.instance().delete(u1);
        TestUserOperations.assertNull((String)"Just deleted user still appears in Database!", (Object)VOMSUserDAO.instance().getByName("U1", "/O=VOMS/O=System/CN=Dummy Certificate Authority"));
        try {
            VOMSUserDAO.instance().delete(u1);
        }
        catch (NoSuchUserException ex) {
            return;
        }
        throw new AssertionFailedError("Double deletion of the same user didn't raise an error!");
    }

    public void testMembership() {
        VOMSGroup g1 = VOMSGroupDAO.instance().create("/org.glite.security.voms.admin.test/g1");
        TestUserOperations.assertNotNull((Object)g1);
        VOMSUser u1 = VOMSUserDAO.instance().create("U1", "/O=VOMS/O=System/CN=Dummy Certificate Authority", null, null, eAddr);
        TestUserOperations.assertNotNull((String)"VOMSUserDAO.createUser returned a null VOMSUser!", (Object)u1);
        u1.addToGroup(g1);
        TestUserOperations.assertTrue((boolean)u1.isMember(g1));
        TestUserOperations.assertTrue((boolean)g1.hasMember(u1));
        VOMSUserDAO.instance().removeFromGroup(u1, g1);
        TestUserOperations.assertFalse((boolean)u1.isMember(g1));
        TestUserOperations.assertFalse((boolean)g1.hasMember(u1));
        u1.addToGroup(g1);
        TestUserOperations.assertTrue((boolean)u1.isMember(g1));
        TestUserOperations.assertTrue((boolean)g1.hasMember(u1));
        VOMSGroupDAO.instance().delete(g1);
        TestUserOperations.assertFalse((boolean)u1.isMember(g1));
        VOMSUserDAO.instance().delete(u1);
    }

    public void testDeletedMapping() {
        VOMSGroup g1 = VOMSGroupDAO.instance().create("/org.glite.security.voms.admin.test/g1");
        TestUserOperations.assertNotNull((Object)g1);
        VOMSUser u1 = VOMSUserDAO.instance().create("U1", "/O=VOMS/O=System/CN=Dummy Certificate Authority", null, null, eAddr);
        TestUserOperations.assertNotNull((String)"VOMSUserDAO.createUser returned a null VOMSUser!", (Object)u1);
        u1.addToGroup(g1);
        TestUserOperations.assertTrue((boolean)u1.isMember(g1));
        TestUserOperations.assertTrue((boolean)g1.hasMember(u1));
        VOMSUserDAO.instance().delete(u1);
        TestUserOperations.assertFalse((boolean)g1.hasMember(u1));
    }

    public void testRoleAssignment() {
        VOMSUser u1 = VOMSUserDAO.instance().create("U1", "/O=VOMS/O=System/CN=Dummy Certificate Authority", null, null, eAddr);
        TestUserOperations.assertNotNull((String)"VOMSUserDAO.createUser returned a null VOMSUser!", (Object)u1);
        VOMSGroup voGroup = VOMSGroupDAO.instance().getVOGroup();
        VOMSGroup g1 = VOMSGroupDAO.instance().findByName("/org.glite.security.voms.admin.test/g1");
        TestUserOperations.assertNotNull((Object)g1);
        VOMSUserDAO.instance().addToGroup(u1, g1);
        VOMSRole r1 = VOMSRoleDAO.instance().create("R1");
        TestUserOperations.assertNotNull((Object)r1);
        VOMSRole r2 = VOMSRoleDAO.instance().create("R2");
        TestUserOperations.assertNotNull((Object)r2);
        VOMSUserDAO.instance().assignRole(u1, voGroup, r1);
        VOMSUserDAO.instance().assignRole(u1, voGroup, r2);
        VOMSUserDAO.instance().assignRole(u1, g1, r2);
        TestUserOperations.assertTrue((boolean)u1.hasRole(voGroup, r1));
        TestUserOperations.assertTrue((boolean)u1.hasRole(voGroup, r2));
        TestUserOperations.assertTrue((boolean)u1.hasRole(g1, r2));
        TestUserOperations.assertFalse((boolean)u1.hasRole(g1, r1));
        TestUserOperations.assertTrue((boolean)r1.isAssignedTo(voGroup, u1));
        TestUserOperations.assertTrue((boolean)r2.isAssignedTo(voGroup, u1));
        TestUserOperations.assertTrue((boolean)r2.isAssignedTo(g1, u1));
        TestUserOperations.assertFalse((boolean)r1.isAssignedTo(g1, u1));
        VOMSRoleDAO.instance().delete(r2);
        TestUserOperations.assertFalse((boolean)r2.isAssignedTo(voGroup, u1));
        TestUserOperations.assertFalse((boolean)r2.isAssignedTo(g1, u1));
        TestUserOperations.assertFalse((boolean)u1.hasRole(voGroup, r2));
        TestUserOperations.assertFalse((boolean)u1.hasRole(g1, r2));
    }

    public void testRoleDismissal() {
        VOMSUser u1 = VOMSUserDAO.instance().getByName("U1", "/O=VOMS/O=System/CN=Dummy Certificate Authority");
        TestUserOperations.assertNotNull((Object)u1);
        VOMSGroup voGroup = VOMSGroupDAO.instance().getVOGroup();
        VOMSRole r1 = VOMSRoleDAO.instance().findByName("R1");
        TestUserOperations.assertNotNull((Object)r1);
        TestUserOperations.assertTrue((boolean)u1.hasRole(voGroup, r1));
        TestUserOperations.assertTrue((boolean)r1.isAssignedTo(voGroup, u1));
        VOMSUserDAO.instance().dismissRole(u1, voGroup, r1);
        TestUserOperations.assertFalse((boolean)u1.hasRole(voGroup, r1));
        TestUserOperations.assertFalse((boolean)r1.isAssignedTo(voGroup, u1));
    }
}

